/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.youpin.feishu.FeiShu;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.monitor.dao.AppGrafanaMappingDao;
import org.apache.ozhera.monitor.dao.model.AppGrafanaMapping;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AA;
import org.apache.ozhera.monitor.service.AppMonitorService;
import org.apache.ozhera.monitor.service.GrafanaService;
import org.apache.ozhera.monitor.service.model.AppMonitorRequest;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.prometheus.MetricSuffix;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    private FeiShu feiShu;
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=AA.class, group="${dubbo.group}")
    private AA aa;
    @Autowired
    private GrafanaService grafanaImpl;
    @Autowired
    AppGrafanaMappingDao appGrafanaMappingDao;
    @Autowired
    AppMonitorService appMonitorService;
    @Autowired
    PrometheusService prometheusService;

    @GetMapping(value={"/test"})
    public String test() {
        this.aa.testA();
        return "OK!";
    }

    @PostMapping(value={"/test/alertManager"})
    public void testAlertManager(@RequestBody String body) {
        System.out.println(body);
    }

    @ResponseBody
    @PostMapping(value={"/getProjects"})
    public Result<PageData> getProjectInfos(@RequestBody AppMonitorRequest param) {
        return this.appMonitorService.getProjectInfos(null, param.getAppName(), param.getPage(), param.getPageSize());
    }

    @GetMapping(value={"/testDb"})
    public String testDb() {
        AppGrafanaMapping app = new AppGrafanaMapping();
        app.setAppName("app2");
        app.setGrafanaUrl("http://baidu.com");
        int i = this.appGrafanaMappingDao.generateGrafanaMapping(app);
        System.out.println("result= " + i);
        AppGrafanaMapping app2 = this.appGrafanaMappingDao.getByAppName("app2");
        return app2.toString();
    }

    @ResponseBody
    @GetMapping(value={"/testpT"})
    public Result<PageData> testPrometheusTotal(String metricP, Long startTimeP, Long endTimeP, Long stepP) {
        String metric;
        Long step;
        Long endTime;
        Long startTime = startTimeP;
        if (startTime == null) {
            startTime = (System.currentTimeMillis() - 604800000L) / 1000L;
        }
        if ((endTime = endTimeP) == null) {
            endTime = System.currentTimeMillis() / 1000L;
        }
        if ((step = stepP) == null) {
            step = 86400L;
        }
        if (StringUtils.isEmpty((CharSequence)(metric = metricP))) {
            metric = "sqlSuccessCount";
        }
        return this.prometheusService.queryRange(metric, null, "667_zzytest", MetricSuffix._total.name(), startTime, endTime, step, null, 0.0);
    }

    @ResponseBody
    @GetMapping(value={"/testpC"})
    public Result<PageData> testPrometheusCount(String metricP, String op, double value, String timeUnit, Long timeDuration, Long startTimeP, Long endTimeP, Long stepP) {
        String metric;
        Long step;
        Long endTime;
        Long startTime = startTimeP;
        if (timeDuration == null || !StringUtils.isEmpty((CharSequence)timeUnit)) {
            // empty if block
        }
        if (startTime == null) {
            startTime = (System.currentTimeMillis() - 604800000L) / 1000L;
        }
        if ((endTime = endTimeP) == null) {
            endTime = System.currentTimeMillis() / 1000L;
        }
        if ((step = stepP) == null) {
            step = 86400L;
        }
        if (StringUtils.isEmpty((CharSequence)(metric = metricP))) {
            metric = "sqlSuccessCount";
        }
        return this.prometheusService.queryRange(metric, null, "667_zzytest", MetricSuffix._count.name(), startTime, endTime, step, op, value);
    }

    @GetMapping(value={"/testpg"})
    public String testGroupPrometheus(HttpServletRequest request, String metricP, Long startTimeP, Long endTimeP, Long stepP) {
        String metric;
        Long step;
        Long endTime;
        AuthUserVo user = UserUtil.getUser();
        log.info("cas user info : {} ", (Object)user.toString());
        Long startTime = startTimeP;
        if (startTime == null) {
            startTime = (System.currentTimeMillis() - 604800000L) / 1000L;
        }
        if ((endTime = endTimeP) == null) {
            endTime = System.currentTimeMillis() / 1000L;
        }
        if ((step = stepP) == null) {
            step = 86400L;
        }
        if (StringUtils.isEmpty((CharSequence)(metric = metricP))) {
            metric = "dubboBisTotalCount";
        }
        List<String> groups = Arrays.asList("serverIp", "serviceName", "methodName");
        String s = this.prometheusService.queryRangeSum(metric, null, "667_zzytest", MetricSuffix._total.name(), startTime, endTime, step, groups);
        return s;
    }
}

