/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.log.api.model.dto.TraceLogDTO;
import org.apache.ozhera.log.api.model.vo.TraceLogQuery;
import org.apache.ozhera.log.api.service.LogDataService;
import org.apache.ozhera.monitor.controller.model.PromQueryRangeParam;
import org.apache.ozhera.monitor.controller.model.TimeUnit;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AppAlarmService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.ozhera.monitor.service.extension.MetricDetailService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDetailQuery;
import org.apache.ozhera.monitor.service.model.prometheus.MiLogQuery;
import org.apache.ozhera.monitor.service.prometheus.AlarmService;
import org.apache.ozhera.monitor.service.prometheus.MetricSuffix;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PrometheusController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusController.class);
    @Autowired
    PrometheusService prometheusService;
    @Autowired
    AlarmService alarmService;
    @Reference(check=false, interfaceClass=LogDataService.class, timeout=5000)
    LogDataService logDataService;
    @Autowired
    AppAlarmService appAlarmService;
    @Autowired
    HeraBaseInfoService heraBaseInfoService;
    @Autowired
    private MetricDetailService metricDetailService;
    @Value(value="${server.type}")
    private String env;

    @ResponseBody
    @PostMapping(value={"/prometheus/queryRange"})
    public Result<PageData> queryRange(@RequestBody PromQueryRangeParam param) {
        log.info("PrometheusController.queryRange request param : {} ", (Object)param.toString());
        Long startTime = param.getStartTime() != null ? param.getStartTime() / 1000L : (System.currentTimeMillis() - 604800000L) / 1000L;
        Long endTime = param.getEndTime() != null ? param.getEndTime() / 1000L : System.currentTimeMillis() / 1000L;
        Long step = param.getStep() != null ? param.getStep() : (endTime - startTime) / 2L;
        String projectName = param.getProjectId() + "_" + param.getProjectName();
        MetricSuffix metricSuffix = MetricSuffix.getByName((String)param.getMetricSuffix()) != null ? MetricSuffix.getByName((String)param.getMetricSuffix()) : MetricSuffix._count;
        log.info("PrometheusController.queryRange request afterConvert Param startTime : {} ,endTime : {} ,step : {},projectName : {},metricSuffix : {}", new Object[]{startTime, endTime, step, projectName, metricSuffix});
        return this.prometheusService.queryRange(param.getMetric(), param.getLabels(), projectName, metricSuffix.name(), startTime, endTime, step, param.getOp(), param.getValue());
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/querySumOverTime"})
    public Result<PageData> querySumOverTime(@RequestBody PromQueryRangeParam param) {
        log.info("PrometheusController.queryRange request param : {} ", (Object)param.toString());
        Long startTime = param.getStartTime() != null ? param.getStartTime() / 1000L : (System.currentTimeMillis() - 604800000L) / 1000L;
        Long endTime = param.getEndTime() != null ? param.getEndTime() / 1000L : System.currentTimeMillis() / 1000L;
        Long duration = endTime - startTime;
        Long step = param.getStep() != null ? param.getStep() : duration;
        String projectName = param.getProjectId() + "_" + param.getProjectName();
        MetricSuffix metricSuffix = MetricSuffix.getByName((String)param.getMetricSuffix()) != null ? MetricSuffix.getByName((String)param.getMetricSuffix()) : MetricSuffix._count;
        log.info("PrometheusController.queryRange request afterConvert Param startTime : {} ,endTime : {} ,step : {},projectName : {},metricSuffix : {}", new Object[]{startTime, endTime, step, projectName, metricSuffix});
        String pDuration = duration + "s";
        return this.prometheusService.queryRangeSumOverTime(param.getMetric(), param.getLabels(), projectName, metricSuffix.name(), startTime, endTime, step, pDuration, param.getSumBy());
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/queryCountOverTime"})
    public Result<PageData> queryCountOverTime(@RequestBody PromQueryRangeParam param) {
        Long startTime = param.getStartTime() != null ? param.getStartTime() / 1000L : (System.currentTimeMillis() - 604800000L) / 1000L;
        Long endTime = param.getEndTime() != null ? param.getEndTime() / 1000L : System.currentTimeMillis() / 1000L;
        Long duration = endTime - startTime;
        Long step = param.getStep() != null ? param.getStep() : duration;
        String projectName = param.getProjectId() + "_" + param.getProjectName();
        MetricSuffix metricSuffix = MetricSuffix.getByName((String)param.getMetricSuffix()) != null ? MetricSuffix.getByName((String)param.getMetricSuffix()) : MetricSuffix._count;
        log.info("PrometheusController.queryRange request afterConvert Param startTime : {} ,endTime : {} ,step : {},projectName : {},metricSuffix : {}", new Object[]{startTime, endTime, step, projectName, metricSuffix});
        String pDuration = duration + "s";
        return this.prometheusService.queryCountOverTime(param.getMetric(), param.getLabels(), projectName, metricSuffix.name(), startTime, endTime, step, pDuration);
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/queryIncrease"})
    public Result<PageData> queryIncrease(@RequestBody PromQueryRangeParam param) {
        Long startTime = param.getStartTime() != null ? param.getStartTime() / 1000L : (System.currentTimeMillis() - 604800000L) / 1000L;
        Long endTime = param.getEndTime() != null ? param.getEndTime() / 1000L : System.currentTimeMillis() / 1000L;
        Long duration = endTime - startTime;
        Long step = param.getStep() != null ? param.getStep() : duration;
        String projectName = param.getProjectId() + "_" + param.getProjectName();
        MetricSuffix metricSuffix = MetricSuffix.getByName((String)param.getMetricSuffix()) != null ? MetricSuffix.getByName((String)param.getMetricSuffix()) : MetricSuffix._count;
        log.info("PrometheusController.queryIncrease request Param startTime : {} ,endTime : {} ,step : {},projectName : {},metricSuffix : {}", new Object[]{startTime, endTime, step, projectName, metricSuffix});
        String pDuration = duration + "s";
        Result pageDataResult = this.prometheusService.queryRangeSumOverTime(param.getMetric(), param.getLabels(), projectName, metricSuffix.name(), startTime, endTime, step, pDuration, param.getSumBy());
        return pageDataResult;
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/instanceIpList"})
    public Result<List<String>> instanceIpList(@RequestBody PromQueryRangeParam param) {
        List instanceIpList = this.alarmService.getInstanceIpList(param.getProjectId(), param.getProjectName());
        log.info("instanceIpList param:{},instanceIpList:{}", (Object)param, (Object)instanceIpList);
        return Result.success((Object)(!CollectionUtils.isEmpty((Collection)instanceIpList) ? instanceIpList.stream().distinct().collect(Collectors.toList()) : instanceIpList));
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/listContainerName"})
    public Result<List<String>> listContainerName(@RequestBody PromQueryRangeParam param) {
        List strings = this.alarmService.listContainerName(param.getProjectId(), param.getProjectName());
        log.info("listContainerName param:{},result:{}", (Object)param.toString(), (Object)strings);
        return Result.success((Object)strings);
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/httpClientDomainList"})
    public Result<List<String>> httpClientDomainList(@RequestBody PromQueryRangeParam param) {
        List httpClientDomainList = this.alarmService.getHttpClientServerDomain(param.getProjectId(), param.getProjectName());
        log.info("httpClientDomainList param:{},httpClientDomainList:{}", (Object)param, (Object)httpClientDomainList);
        return Result.success((Object)(!CollectionUtils.isEmpty((Collection)httpClientDomainList) ? httpClientDomainList.stream().distinct().collect(Collectors.toList()) : httpClientDomainList));
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/serverEnvList"})
    public Result<Map> serverEnvList(@RequestBody PromQueryRangeParam param) {
        Map map = this.alarmService.getEnvIpMapping(param.getProjectId(), param.getProjectName());
        log.info("instanceIpList param:{},map:{}", (Object)param, (Object)map);
        return Result.success((Object)map);
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/detail"})
    public Result<PageData> detail(@RequestBody MetricDetailQuery param) {
        log.info("PrometheusController detail param : {}", (Object)param);
        return this.metricDetailService.metricDetail(param);
    }

    @ResponseBody
    @PostMapping(value={"/prometheus/logInfo"})
    public Result<PageData> logInfo(@RequestBody MiLogQuery param) {
        TraceLogQuery query = new TraceLogQuery(param.getProjectId(), param.getServerIp(), param.getTraceId());
        query.setGenerationTime(param.getGenerationTime());
        query.setLevel(param.getLevel());
        try {
            PageData pd = new PageData();
            TraceLogDTO traceLog = this.logDataService.getTraceLog(query);
            log.info("getTraceLog param : {},result:{}", (Object)param, (Object)traceLog.toString());
            Set dataList = traceLog.getDataList();
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return Result.success((Object)pd);
            }
            pd.setTotal(Long.valueOf(dataList.size()));
            pd.setList((Object)dataList);
            return Result.success((Object)pd);
        }
        catch (Exception e) {
            log.error("PrometheusController.logInfo Error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @GetMapping(value={"/prometheus/getTeslaError"})
    public Result<PageData> getTeslaError(String department, String area) {
        if (StringUtils.isEmpty((CharSequence)department) || StringUtils.isEmpty((CharSequence)area)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return this.prometheusService.getTeslaError(department, area);
    }

    private Long convertStartTime(PromQueryRangeParam param) {
        if (param.getTimeDuration() == null || param.getTimeDuration().intValue() <= 0 || StringUtils.isEmpty((CharSequence)param.getTimeUnit())) {
            log.info("PrometheusController.convertQueryTime invalid timeDuration or timeUnit param! param : {} ", (Object)param);
            return null;
        }
        TimeUnit timeUnit = TimeUnit.getByName(param.getTimeUnit());
        if (timeUnit == null) {
            log.info("PrometheusController.convertQueryTime no allowed timeUnit! timeUnit : {} ", (Object)param.getTimeUnit());
            return null;
        }
        switch (timeUnit) {
            case m: {
                return System.currentTimeMillis() / 1000L - param.getTimeDuration() * 60L;
            }
            case h: {
                return System.currentTimeMillis() / 1000L - param.getTimeDuration() * 60L * 60L;
            }
            case d: {
                return System.currentTimeMillis() / 1000L - param.getTimeDuration() * 60L * 60L * 24L;
            }
        }
        return null;
    }

    @GetMapping(value={"/api/prometheus/getServiceQps"})
    public Result getServiceQps(String serviceName, String type) {
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return this.prometheusService.getServiceQps(serviceName, type);
    }

    @GetMapping(value={"/api/prometheus/getDubboServiceList"})
    public Result getDubboServiceList(String serviceName, String type, String startTime, String endTime) {
        if (StringUtils.isEmpty((CharSequence)serviceName) || StringUtils.isEmpty((CharSequence)startTime) || StringUtils.isEmpty((CharSequence)endTime) || Long.parseLong(startTime) > Long.parseLong(endTime)) {
            return Result.fail((ErrorCode)ErrorCode.success);
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = "dubbo";
        }
        return this.prometheusService.queryDubboServiceList(serviceName, type, startTime, endTime);
    }

    @GetMapping(value={"/api/prometheus/oracle"})
    public Result oracle(String mode, String type) {
        this.prometheusService.oracle(mode, type);
        return Result.success((Object)"test");
    }
}

