/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AppGrafanaMappingService;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GrafanaMappingController {
    private static final Logger log = LoggerFactory.getLogger(GrafanaMappingController.class);
    @Autowired
    AppGrafanaMappingService appGrafanaMappingService;
    @Autowired
    PlatFormTypeExtensionService platFormTypeExtensionService;

    @GetMapping(value={"/mimonitor/getGrafanaUrlByAppName"})
    public Result getGrafanaUrlByAppName(String appName) {
        return this.appGrafanaMappingService.getGrafanaUrlByAppName(appName);
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/getGrafanaUrlByAppId"})
    public Result<String> getGrafanaUrlByAppId(Integer appId) {
        return this.appGrafanaMappingService.getGrafanaUrlByAppId(appId);
    }

    @GetMapping(value={"/api-manual/test"})
    public String manualTest() {
        log.info("GrafanaMappingController.manualTest ...");
        return "ooooook!!!";
    }

    @GetMapping(value={"/api-manual/mimonitor/createGrafanaUrlByBaseInfo"})
    public String createGrafanaUrlByBaseInfo(Integer appId, String appName, String plat, Integer appType, String language) {
        log.info("GrafanaMappingController.createGrafanaUrlByBaseInfo request appId:{},appName:{},plat{},appType:{},language:{}", new Object[]{appId, appName, plat, appType, language});
        HeraAppBaseInfoModel baseInfo = new HeraAppBaseInfoModel();
        baseInfo.setBindId("" + appId);
        baseInfo.setAppName(appName);
        baseInfo.setPlatformType(this.platFormTypeExtensionService.getTypeCodeByName(plat));
        baseInfo.setAppType(appType);
        baseInfo.setAppLanguage(language);
        this.appGrafanaMappingService.createTmpByAppBaseInfo(baseInfo);
        return "Success!";
    }

    @GetMapping(value={"/mimonitor/loadGrafanaTemplateBase"})
    public Result loadGrafanaTemplateBase(Integer id) {
        if (id == null) {
            log.error("loadGrafanaTemplateBase invalid param id is null!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        try {
            this.appGrafanaMappingService.reloadTmpByAppId(id);
        }
        catch (Exception e) {
            log.error("loadGrafanaTemplateBase error!{}", (Object)e.getMessage(), (Object)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)"success");
    }

    @PostMapping(value={"/mimonitor/reloadTemplateBase"})
    public Result reloadTemplateBaseByPage() {
        log.info("GrafanaMappingController.reloadTemplateBase start ...");
        Integer pSize = 100;
        this.appGrafanaMappingService.exeReloadTemplateBase(pSize);
        return Result.success((Object)"task has executed!");
    }
}

