/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.Borning;
import org.nutz.lang.inject.Injecting;
import org.nutz.mvc.adaptor.ParamConvertor;
import org.nutz.mvc.adaptor.ParamExtractor;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.adaptor.Params;
import org.nutz.mvc.annotation.Param;

public class ObjectPairInjector
implements ParamInjector {
    protected Injecting[] injs;
    protected String[] names;
    protected Mirror<?> mirror;
    protected Field[] fields;
    protected ParamConvertor[] converters;
    protected Borning<?> borning;
    protected String[] defaultValues;

    public ObjectPairInjector(String prefix, Type type) {
        prefix = Strings.isBlank(prefix) ? "" : Strings.trim(prefix);
        this.mirror = Mirror.me(type);
        this.borning = this.mirror.getBorning(new Object[0]);
        this.fields = this.mirror.getFields();
        this.injs = new Injecting[this.fields.length];
        this.names = new String[this.fields.length];
        this.converters = new ParamConvertor[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            Field f = this.fields[i];
            this.injs[i] = this.mirror.getInjecting(f.getName());
            Param param = f.getAnnotation(Param.class);
            String nm = null == param ? f.getName() : param.value();
            String datefmt = null == param ? null : param.dfmt();
            String locale = null == param ? null : param.locale();
            this.names[i] = prefix + nm;
            this.converters[i] = Params.makeParamConvertor(f.getType(), datefmt, locale);
            if (param == null || "//NOT EXIST IN//".equals(param.df())) continue;
            if (this.defaultValues == null) {
                this.defaultValues = new String[this.fields.length];
            }
            this.defaultValues[i] = param.df();
        }
    }

    @Override
    public Object get(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, Object refer) {
        ParamExtractor pe = Params.makeParamExtractor(req, refer);
        Object obj = this.borning.born(new Object[0]);
        for (int i = 0; i < this.injs.length; ++i) {
            Object param = this.converters[i].convert(pe.extractor(this.names[i]));
            if (param == null && this.defaultValues != null && this.defaultValues[i] != null) {
                param = this.defaultValues[i];
            }
            if (null == param) continue;
            this.injs[i].inject(obj, param);
        }
        return obj;
    }
}

