/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.socket.json;

import java.io.IOException;
import java.io.Writer;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.nutz.json.Json;
import org.nutz.json.JsonException;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketActionTable;
import org.nutz.lang.socket.SocketAtom;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class SocketJsonAtom
extends SocketAtom {
    private static final Log log = Logs.get();

    public SocketJsonAtom(Context context, Socket socket, SocketActionTable saTable) {
        super(context, socket, saTable);
    }

    @Override
    public void doRun() throws IOException {
        block14: {
            StringBuilder sb = new StringBuilder();
            this.line = this.br.readLine();
            while (null != this.line) {
                if (this.context.getBoolean("stop")) {
                    return;
                }
                sb.append(this.line).append('\n');
                if (Strings.isBlank(this.line)) break;
                this.line = this.br.readLine();
            }
            if (log.isDebugEnabled()) {
                log.debug("  <<socket<<: " + sb);
            }
            try {
                LinkedHashMap map = Json.fromJson(LinkedHashMap.class, (CharSequence)sb.toString());
                if (map == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("Null data ???!!");
                    }
                    return;
                }
                SocketAction action = this.saTable.get(map.get("cmd").toString());
                if (null != action) {
                    if (log.isDebugEnabled()) {
                        log.debugf("handle request by " + action, new Object[0]);
                    }
                    SocketContext context = new SocketContext(this);
                    context.set("json_data", map);
                    action.run(context);
                    if (log.isDebugEnabled()) {
                        log.debugf("finish request by " + action, new Object[0]);
                    }
                    break block14;
                }
                if (log.isWarnEnabled()) {
                    log.warn("Unknown CMD=" + map.get("cmd"));
                }
                Writer writer = Streams.utf8w(this.ops);
                HashMap<String, Object> x = new HashMap<String, Object>();
                x.put("ok", false);
                x.put("msg", "Unknown CMD");
                Json.toJson(writer, x);
                try {
                    writer.close();
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn("Error to write...", e);
                    }
                }
            }
            catch (JsonException e) {
                if (!log.isWarnEnabled()) break block14;
                log.warnf("Json error > %s : \n<%s>", e.getMessage(), sb);
            }
        }
    }
}

