/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.meta;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocValue;
import org.nutz.json.Json;

public class IocObject
implements Cloneable {
    private Class<?> type;
    private boolean singleton = true;
    private IocEventSet events;
    private List<IocValue> args = new ArrayList<IocValue>();
    private Map<String, IocField> fields = new LinkedHashMap<String, IocField>();
    private String scope;
    private String factory;

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public IocEventSet getEvents() {
        return this.events;
    }

    public void setEvents(IocEventSet events) {
        this.events = events;
    }

    public IocValue[] getArgs() {
        return this.args.toArray(new IocValue[this.args.size()]);
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public void addArg(IocValue arg) {
        this.args.add(arg);
    }

    public void copyArgys(IocValue[] args) {
        this.args.clear();
        for (IocValue arg : args) {
            this.addArg(arg);
        }
    }

    public Map<String, IocField> getFields() {
        return this.fields;
    }

    public void addField(IocField field) {
        this.fields.put(field.getName(), field);
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public IocObject clone() {
        return Json.fromJson(IocObject.class, (CharSequence)Json.toJson(this));
    }

    public String toString() {
        return Json.toJson(this);
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getFactory() {
        return this.factory;
    }
}

