/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Ioc2;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.IocEventListener;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.ObjectMaker;
import org.nutz.ioc.ObjectProxy;
import org.nutz.ioc.ValueProxyMaker;
import org.nutz.ioc.annotation.InjectName;
import org.nutz.ioc.aop.MirrorFactory;
import org.nutz.ioc.aop.impl.DefaultMirrorFactory;
import org.nutz.ioc.impl.ComboContext;
import org.nutz.ioc.impl.DefaultValueProxyMaker;
import org.nutz.ioc.impl.ObjectMakerImpl;
import org.nutz.ioc.impl.ScopeContext;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.ioc.meta.IocObject;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.LifeCycle;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.repo.LevenshteinDistance;

public class NutIoc
implements Ioc2 {
    private static final Log log = Logs.get();
    private Object lock_get = new Object();
    private static final String DEF_SCOPE = "app";
    protected Date createTime;
    private ComboIocLoader loader;
    private IocContext context;
    private ObjectMaker maker;
    private List<ValueProxyMaker> vpms;
    private MirrorFactory mirrors;
    private String defaultScope;
    private Set<String> supportedTypes;
    protected List<IocEventListener> listeners;
    protected ThreadLocal<Object> listenerH = new ThreadLocal();
    private boolean deposed = false;

    public NutIoc(IocLoader loader) {
        this(loader, new ScopeContext(DEF_SCOPE), DEF_SCOPE);
    }

    public NutIoc(IocLoader loader, IocContext context, String defaultScope) {
        this(new ObjectMakerImpl(), loader, context, defaultScope);
    }

    protected NutIoc(ObjectMaker maker, IocLoader loader, IocContext context, String defaultScope) {
        this(maker, loader, context, defaultScope, null);
    }

    protected NutIoc(ObjectMaker maker, IocLoader loader, IocContext context, String defaultScope, MirrorFactory mirrors) {
        this.createTime = new Date();
        this.maker = maker;
        this.defaultScope = defaultScope;
        this.context = context;
        this.loader = loader instanceof ComboIocLoader ? (ComboIocLoader)loader : new ComboIocLoader(loader);
        this.vpms = new ArrayList<ValueProxyMaker>(5);
        this.addValueProxyMaker(new DefaultValueProxyMaker());
        this.mirrors = mirrors == null ? new DefaultMirrorFactory(this) : mirrors;
        try {
            this.loader.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("... NutIoc init complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IocLoading createLoading() {
        if (null == this.supportedTypes) {
            NutIoc nutIoc = this;
            synchronized (nutIoc) {
                if (null == this.supportedTypes) {
                    this.supportedTypes = new HashSet<String>();
                    for (ValueProxyMaker maker : this.vpms) {
                        String[] ss = maker.supportedTypes();
                        if (ss == null) continue;
                        for (String s : ss) {
                            this.supportedTypes.add(s);
                        }
                    }
                }
            }
        }
        return new IocLoading(this.supportedTypes);
    }

    @Override
    public <T> T get(Class<T> type) throws IocException {
        InjectName inm = type.getAnnotation(InjectName.class);
        if (null != inm && !Strings.isBlank(inm.value())) {
            return this.get(type, inm.value());
        }
        IocBean iocBean = type.getAnnotation(IocBean.class);
        if (iocBean != null && !Strings.isBlank(iocBean.name())) {
            return this.get(type, iocBean.name());
        }
        return this.get(type, Strings.lowerFirst(type.getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type, String name, IocContext context) throws IocException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debugf("Get '%s'<%s>", name, type == null ? "" : type);
        }
        try {
            if (this.mirrors instanceof LifeCycle) {
                ((LifeCycle)((Object)this.mirrors)).init();
            }
        }
        catch (Exception e) {
            throw new IocException("_mirror_factory_init", (Throwable)e, "Mirror Factory init fail", new Object[0]);
        }
        IocMaking ing = this.makeIocMaking(context, name);
        IocContext cntx = ing.getContext();
        ObjectProxy op = cntx.fetch(name);
        if (null == op) {
            object = this.lock_get;
            synchronized (object) {
                block28: {
                    op = cntx.fetch(name);
                    if (null == op) {
                        try {
                            IocObject iobj;
                            if (log.isDebugEnabled()) {
                                log.debug("\t >> Load definition name=" + name);
                            }
                            if (null == (iobj = this.loader.load(this.createLoading(), name))) {
                                for (String iocBeanName : this.loader.getName()) {
                                    if (3 <= LevenshteinDistance.computeLevenshteinDistance(name.toLowerCase(), iocBeanName.toLowerCase())) continue;
                                    throw new IocException(name, "Undefined object '%s' but found similar name '%s'", name, iocBeanName);
                                }
                                throw new IocException(name, "Undefined object '%s'", name);
                            }
                            if (null == iobj.getType()) {
                                if (null == type && Strings.isBlank(iobj.getFactory())) {
                                    throw new IocException(name, "NULL TYPE object '%s'", name);
                                }
                                iobj.setType(type);
                            }
                            if (Strings.isBlank(iobj.getScope())) {
                                iobj.setScope(this.defaultScope);
                            }
                            if (log.isDebugEnabled()) {
                                log.debugf("\t >> Make...'%s'<%s>", name, type == null ? "" : type);
                            }
                            if (iobj.getType() != null && IocEventListener.class.isAssignableFrom(iobj.getType())) {
                                if (this.listenerH.get() != null) {
                                    op = this.maker.make(ing, iobj);
                                    break block28;
                                }
                                try {
                                    this.listenerH.set(Boolean.TRUE);
                                    op = this.maker.make(ing, iobj);
                                    break block28;
                                }
                                finally {
                                    this.listenerH.remove();
                                }
                            }
                            this._checkIocEventListeners();
                            ing.setListeners(this.listeners);
                            op = this.maker.make(ing, iobj);
                        }
                        catch (IocException e) {
                            e.addBeanNames(name);
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new IocException(name, e, "For object [%s] - type:[%s]", name, type == null ? "" : type);
                        }
                    }
                }
            }
        }
        object = this.lock_get;
        synchronized (object) {
            T re = op.get(type, ing);
            if (!name.startsWith("$") && re instanceof IocLoader) {
                this.loader.addLoader((IocLoader)re);
            }
            return re;
        }
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        return this.get(type, name, null);
    }

    @Override
    public boolean has(String name) {
        return this.loader.has(name) || this.context.fetch(name) != null;
    }

    @Override
    public void depose() {
        if (this.deposed) {
            if (log.isInfoEnabled()) {
                log.info("You can't depose a Ioc twice!");
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.infof("%s@%s is closing. startup date [%s]", this.getClass().getName(), this.hashCode(), Times.sDTms2(this.createTime));
        }
        try {
            this.loader.depose();
        }
        catch (Exception e) {
            log.warn("something happen when depose IocLoader", e);
        }
        this.context.depose();
        this.loader.clear();
        this.deposed = true;
        if (log.isInfoEnabled()) {
            log.infof("%s@%s is deposed. startup date [%s]", this.getClass().getName(), this.hashCode(), Times.sDTms2(this.createTime));
        }
    }

    @Override
    public void reset() {
        this.context.clear();
    }

    @Override
    public String[] getNames() {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        list.addAll(Arrays.asList(this.loader.getName()));
        if (this.context != null) {
            list.addAll(this.context.names());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void addValueProxyMaker(ValueProxyMaker vpm) {
        this.vpms.add(0, vpm);
        this.supportedTypes = null;
        this.loader.clear();
    }

    @Override
    public IocContext getIocContext() {
        return this.context;
    }

    public void setMaker(ObjectMaker maker) {
        this.maker = maker;
    }

    public void setMirrorFactory(MirrorFactory mirrors) {
        this.mirrors = mirrors;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    public IocMaking makeIocMaking(IocContext context, String name) {
        IocContext cntx;
        if (null == context || context == this.context) {
            cntx = this.context;
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Link contexts");
            }
            cntx = new ComboContext(context, this.context);
        }
        return new IocMaking(this, this.mirrors, cntx, this.maker, this.vpms, name);
    }

    public String toString() {
        return "/*NutIoc count=" + this.loader.getName().length + "*/";
    }

    protected void finalize() throws Throwable {
        if (!this.deposed) {
            log.error("Ioc depose tigger by GC!!!\nCommon Reason for that is YOUR code call 'new NutIoc(...)', and then get some beans(most is Dao) from it and abandon it!!!\nIf using nutz.mvc, call Mvcs.ctx().getDefaultIoc() to get ioc container.\nNot nutz.mvc? use like this:     public static Ioc ioc;");
            this.depose();
        }
        super.finalize();
    }

    @Override
    public String[] getNamesByType(Class<?> klass) {
        return this.getNamesByType(klass, null);
    }

    @Override
    public String[] getNamesByType(Class<?> klass, IocContext context) {
        ArrayList<String> names = new ArrayList<String>(this.loader.getNamesByTypes(this.createLoading(), klass));
        IocContext cntx = null == context || context == this.context ? this.context : new ComboContext(context, this.context);
        for (String name : cntx.names()) {
            ObjectProxy op = cntx.fetch(name);
            if (op.getObj() == null || !klass.isAssignableFrom(op.getObj().getClass())) continue;
            names.add(name);
        }
        LinkedHashSet<String> re = new LinkedHashSet<String>();
        for (String name : names) {
            if (Strings.isBlank(name) || "null".equals(name)) continue;
            re.add(name);
        }
        return re.toArray(new String[re.size()]);
    }

    @Override
    public String[] getNamesByAnnotation(Class<? extends Annotation> klass) {
        return this.getNamesByAnnotation(klass, null);
    }

    @Override
    public String[] getNamesByAnnotation(Class<? extends Annotation> klass, IocContext context) {
        ArrayList<String> names = new ArrayList<String>(this.loader.getNamesByAnnotation(this.createLoading(), klass));
        IocContext cntx = null == context || context == this.context ? this.context : new ComboContext(context, this.context);
        for (String name : cntx.names()) {
            ObjectProxy op = cntx.fetch(name);
            if (op.getObj() == null || klass.getAnnotation(klass) == null) continue;
            names.add(name);
        }
        LinkedHashSet<String> re = new LinkedHashSet<String>();
        for (String name : names) {
            if (Strings.isBlank(name) || "null".equals(name)) continue;
            re.add(name);
        }
        return re.toArray(new String[re.size()]);
    }

    @Override
    public <K> K getByType(Class<K> klass) {
        return this.getByType(klass, (IocContext)null);
    }

    public <K> K getByType(Class<K> klass, IocContext context) {
        String _name = null;
        IocContext cntx = null == context || context == this.context ? this.context : new ComboContext(context, this.context);
        for (String name : cntx.names()) {
            ObjectProxy op = cntx.fetch(name);
            if (op.getObj() == null || !klass.isAssignableFrom(op.getObj().getClass())) continue;
            _name = name;
            break;
        }
        if (_name != null) {
            return this.get(klass, _name, context);
        }
        for (String name : this.getNames()) {
            block5: {
                try {
                    IocObject iobj = this.loader.load(this.createLoading(), name);
                    if (iobj == null || iobj.getType() == null || !klass.isAssignableFrom(iobj.getType())) break block5;
                    _name = name;
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (_name == null) continue;
            return this.get(klass, name, context);
        }
        throw new IocException("class:" + klass.getName(), "none ioc bean match class=" + klass.getName(), new Object[0]);
    }

    protected void _checkIocEventListeners() {
        if (this.listeners != null) {
            return;
        }
        ArrayList<IocEventListener> listeners = new ArrayList<IocEventListener>();
        for (String beanName : this.loader.getNamesByTypes(this.createLoading(), IocEventListener.class)) {
            listeners.add(this.get(IocEventListener.class, beanName));
        }
        if (listeners.size() > 0) {
            Collections.sort(listeners, new Comparator<IocEventListener>(){

                @Override
                public int compare(IocEventListener prev, IocEventListener next) {
                    if (prev.getOrder() == next.getOrder()) {
                        return 0;
                    }
                    return prev.getOrder() > next.getOrder() ? -1 : 1;
                }
            });
        }
        this.listeners = listeners;
    }

    @Override
    public Ioc addBean(String name, Object obj) {
        if (obj == null) {
            throw new RuntimeException("can't add bean=null!!");
        }
        if (Strings.isBlank(name)) {
            throw new RuntimeException("can't add bean name is blank!!");
        }
        if (obj instanceof ObjectProxy) {
            this.getIocContext().save(DEF_SCOPE, name, (ObjectProxy)obj);
        } else {
            this.getIocContext().save(DEF_SCOPE, name, new ObjectProxy(obj));
        }
        return this;
    }

    @Override
    public Class<?> getType(String beanName) throws ObjectLoadException {
        return this.getType(beanName, null);
    }

    @Override
    public Class<?> getType(String beanName, IocContext context) throws ObjectLoadException {
        IocContext cntx = null == context || context == this.context ? this.context : new ComboContext(context, this.context);
        ObjectProxy op = cntx.fetch(beanName);
        if (op != null && op.getObj() != null) {
            return op.getObj().getClass();
        }
        return this.loader.getType(this.createLoading(), beanName);
    }
}

