/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el;

import java.util.Map;
import java.util.Queue;
import org.nutz.el.ElException;
import org.nutz.el.arithmetic.RPN;
import org.nutz.el.arithmetic.ShuntingYard;
import org.nutz.lang.Lang;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.util.Context;

public class El {
    private RPN rc = null;
    private CharSequence elstr = "";

    public El() {
    }

    public El(CharSequence cs) {
        this.elstr = cs;
        ShuntingYard sy = new ShuntingYard();
        Queue<Object> rpn = sy.parseToRPN(cs.toString());
        this.rc = new RPN(rpn);
    }

    public Object eval(Context context) {
        if (this.rc == null) {
            throw new ElException("\u6ca1\u6709\u8fdb\u884c\u9884\u7f16\u8bd1!");
        }
        return this.rc.calculate(context);
    }

    public static Object eval(String val) {
        return El.eval(null, val);
    }

    public static Object eval(Context context, String val) {
        ShuntingYard sy = new ShuntingYard();
        RPN rc = new RPN();
        Queue<Object> rpn = sy.parseToRPN(val);
        return rc.calculate(context, rpn);
    }

    public String toString() {
        return this.elstr.toString();
    }

    public static String render(String seg, Context ctx) {
        return El.render(new CharSegment(seg), ctx);
    }

    public static String render(CharSegment seg, Context ctx) {
        Context main = Lang.context();
        for (String key : seg.keys()) {
            main.putAll(key, new El(key).eval(ctx));
        }
        return seg.render(main).toString();
    }

    public static String render(CharSegment seg, Map<String, El> els, Context ctx) {
        Context main = Lang.context();
        for (String key : seg.keys()) {
            El el = els.get(key);
            if (el == null) {
                el = new El(key);
            }
            main.putAll(key, el.eval(ctx));
        }
        return seg.render(main).toString();
    }
}

