/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkType;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.NutEntity;
import org.nutz.dao.impl.entity.field.AbstractLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public class ManyLinkField
extends AbstractLinkField {
    public ManyLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info) {
        super(entity, holder, info);
        this.targetType = this.guessTargetClass(info, info.many.target());
        this.mapKey = info.many.key();
        Entity<?> ta = this.getLinkedEntity();
        if (Strings.isBlank(info.many.field())) {
            this.hostField = null;
            this.linkedField = null;
            return;
        }
        String targetFieldName = "_".equals(info.many.field()) ? Strings.lowerFirst(this.getEntity().getType().getSimpleName()) + "Id" : info.many.field();
        this.linkedField = ta.getField(targetFieldName);
        if (null == this.linkedField) {
            throw new DaoException(String.format("host class=%s, props=%s @Many(field=\"%s\",key=\"%s\")) expect prop=%s found at target class=%s", this.getEntity().getType().getName(), info.name, targetFieldName, info.many.key(), targetFieldName, this.targetType.getName()));
        }
        boolean intLike = this.linkedField.getTypeMirror().isIntLike();
        if (Strings.isBlank(this.mapKey) || Mirror.me(info.fieldType).isMap()) {
            MappingField mappingField = this.hostField = intLike ? this.getEntity().getIdField() : this.getEntity().getNameField();
            if (this.hostField == null) {
                throw new DaoException(String.format("host class=%s, prop=%s @Many(field=\"%s\",key=\"%s\")) expect any field %s found at target class=%s", this.getEntity().getType().getName(), info.name, targetFieldName, info.many.key(), intLike ? "@Id" : "@Name", this.targetType.getName()));
            }
        } else {
            this.hostField = this.getEntity().getField(this.mapKey);
            if (this.hostField == null) {
                throw new DaoException(String.format("host class=%s, prop=%s @Many(field=\"%s\",key=\"%s\")) expect prop=%s found at target class=%s", this.getEntity().getType().getName(), info.name, targetFieldName, info.many.key(), this.mapKey, this.targetType.getName()));
            }
        }
    }

    public ManyLinkField(NutEntity<?> en, EntityHolder holder, LinkInfo info, Class<?> klass, MappingField mf, MappingField mfKey) {
        super(en, holder, info);
        this.targetType = klass;
        this.hostField = mf;
        this.linkedField = mfKey;
    }

    @Override
    public Condition createCondition(Object host) {
        return null == this.linkedField ? null : Cnd.where(this.linkedField.getName(), "=", this.hostField.getValue(host));
    }

    @Override
    public void updateLinkedField(Object obj, Object linked) {
        if (null != this.hostField) {
            final Object v = this.hostField.getValue(obj);
            Lang.each(linked, new Each<Object>(){

                @Override
                public void invoke(int i, Object ele, int length) throws ExitLoop, LoopException {
                    ManyLinkField.this.linkedField.setValue(ele, v);
                }
            });
        }
    }

    @Override
    public MappingField getHostField() {
        return this.hostField;
    }

    @Override
    public MappingField getLinkedField() {
        return this.linkedField;
    }

    @Override
    public void saveLinkedField(Object obj, Object linked) {
    }

    @Override
    public LinkType getLinkType() {
        return LinkType.MANY;
    }
}

