/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.init_sql;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xiaomi.youpin.docean.anno.Service;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateDetailMapper;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTemplateDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTemplateDetailDO;
import org.apache.ozhera.log.manager.service.BaseService;
import org.jetbrains.annotations.NotNull;

@Service
public class HeraLogTemplateService
extends BaseService {
    @Resource
    private MilogLogTemplateMapper milogLogTemplateMapper;
    @Resource
    private MilogLogTemplateDetailMapper milogLogTemplateDetailMapper;

    public void init() {
        for (LogTypeEnum typeEnum : LogTypeEnum.values()) {
            MilogLogTemplateDO logTemplateDO;
            MilogLogTemplateDetailDO detailDO;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"type", (Object)typeEnum.getType());
            List templateDOS = this.milogLogTemplateMapper.selectList((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)templateDOS) || null != (detailDO = this.milogLogTemplateDetailMapper.getByTemplateId((logTemplateDO = this.getInsertLogTemplateDO(typeEnum, Arrays.stream(MachineRegionEnum.values()).map(MachineRegionEnum::getEn).collect(Collectors.joining(",")))).getId()))) continue;
            this.insertTemplateDetail(typeEnum, logTemplateDO);
        }
    }

    private void insertTemplateDetail(LogTypeEnum typeEnum, MilogLogTemplateDO logTemplateDO) {
        MilogLogTemplateDetailDO detailDO = new MilogLogTemplateDetailDO();
        detailDO.setTemplateId(logTemplateDO.getId().toString());
        if (typeEnum == LogTypeEnum.APP_LOG_MULTI) {
            detailDO.setPropertiesKey("timestamp:1,level:1,traceId:1,threadName:1,className:1,line:1,methodName:1,message:1,logstore:3,logsource:3,mqtopic:3,mqtag:3,logip:3,tail:3,linenumber:3,podName:1");
            detailDO.setPropertiesType("date,keyword,keyword,text,text,keyword,keyword,text,keyword,keyword,keyword,keyword,keyword,keyword,long,keyword");
        }
        if (typeEnum == LogTypeEnum.NGINX) {
            detailDO.setPropertiesKey("message:1,hostname:1,http_code:1,method:1,protocol:1,referer:1,timestamp:1,ua:1,url:1,linenumber:3,logip:3");
            detailDO.setPropertiesType("text,text,keyword,keyword,keyword,text,timestamp,text,text,long,keyword");
        }
        if (typeEnum == LogTypeEnum.OPENTELEMETRY) {
            detailDO.setPropertiesKey("logstore:3,logsource:3,mqtopic:3,mqtag:3,logip:3,tail:3,linenumber:3");
            detailDO.setPropertiesType("keyword,keyword,keyword,keyword,keyword,keyword,long");
        }
        if (typeEnum == LogTypeEnum.DOCKER) {
            detailDO.setPropertiesKey("logstore:3,logsource:3,mqtopic:3,mqtag:3,logip:3,tail:3,linenumber:3");
            detailDO.setPropertiesType("keyword,keyword,keyword,keyword,keyword,keyword,long");
        }
        if (typeEnum == LogTypeEnum.APP_LOG_SIGNAL) {
            detailDO.setPropertiesKey("timestamp:1,level:1,traceId:1,threadName:1,className:1,line:1,methodName:1,message:1,logstore:3,logsource:3,mqtopic:3,mqtag:3,logip:3,tail:3,linenumber:3,podName:1");
            detailDO.setPropertiesType("date,keyword,keyword,text,text,keyword,keyword,text,keyword,keyword,keyword,keyword,keyword,keyword,long,keyword");
        }
        if (typeEnum == LogTypeEnum.ORIGIN_LOG) {
            detailDO.setPropertiesKey("timestamp:1,level:1,traceId:1,threadName:1,className:1,line:1,methodName:1,message:1,logstore:3,logsource:3,mqtopic:3,mqtag:3,logip:3,tail:3,linenumber:3,podName:1");
            detailDO.setPropertiesType("date,keyword,keyword,text,text,keyword,keyword,text,keyword,keyword,keyword,keyword,keyword,keyword,long,keyword");
        }
        if (typeEnum == LogTypeEnum.FREE) {
            detailDO.setPropertiesKey("logstore:3,logsource:3,mqtopic:3,mqtag:3,logip:3,tail:3,linenumber:3");
            detailDO.setPropertiesType("keyword,keyword,keyword,keyword,keyword,keyword,long");
        }
        detailDO.setCtime(Instant.now().toEpochMilli());
        detailDO.setUtime(Instant.now().toEpochMilli());
        this.milogLogTemplateDetailMapper.insert(detailDO);
    }

    @NotNull
    private MilogLogTemplateDO getInsertLogTemplateDO(LogTypeEnum typeEnum, String supportArea) {
        MilogLogTemplateDO logTemplateDO = new MilogLogTemplateDO();
        logTemplateDO.setTemplateName(typeEnum.getTypeName());
        logTemplateDO.setType(typeEnum.getType());
        logTemplateDO.setOrderCol(typeEnum.getSort());
        logTemplateDO.setSupportArea(supportArea);
        logTemplateDO.setSupportedConsume(typeEnum.getSupportedConsume());
        logTemplateDO.setCtime(Instant.now().toEpochMilli());
        logTemplateDO.setUtime(Instant.now().toEpochMilli());
        this.milogLogTemplateMapper.insert(logTemplateDO);
        return logTemplateDO;
    }
}

