/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.xiaomi.youpin.docean.anno.Service;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.model.bo.MilogDictionaryParam;
import org.apache.ozhera.log.manager.model.dto.DictionaryDTO;
import org.apache.ozhera.log.manager.model.dto.MotorRoomDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.MilogDictionaryService;
import org.apache.ozhera.log.manager.service.extension.dictionary.DictionaryExtensionService;
import org.apache.ozhera.log.manager.service.extension.dictionary.DictionaryExtensionServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogDictionaryServiceImpl
implements MilogDictionaryService {
    private static final Logger log = LoggerFactory.getLogger(MilogDictionaryServiceImpl.class);
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private MilogLogstoreDao milogLogstoreDao;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    private DictionaryExtensionService dictionaryExtensionService;

    public void init() {
        this.dictionaryExtensionService = DictionaryExtensionServiceFactory.getDictionaryExtensionService();
    }

    @Override
    public Result<Map<Integer, List<DictionaryDTO<?>>>> queryDictionaryList(MilogDictionaryParam dictionaryParam) {
        if (null == dictionaryParam || CollectionUtils.isEmpty(dictionaryParam.getCodes())) {
            return Result.failParam((String)"code Cannot be empty");
        }
        if (CollectionUtils.isNotEmpty((Collection)dictionaryParam.getCodes().stream().filter(code -> code == 1003).collect(Collectors.toList())) && null == dictionaryParam.getMiddlewareId()) {
            return Result.failParam((String)"middlewareId Cannot be empty");
        }
        if (CollectionUtils.isNotEmpty((Collection)dictionaryParam.getCodes().stream().filter(code -> code == 1005).collect(Collectors.toList())) && StringUtils.isEmpty((CharSequence)dictionaryParam.getNameEn())) {
            return Result.failParam((String)"nameEn Cannot be empty");
        }
        HashMap dictionaryDTO = Maps.newHashMap();
        dictionaryParam.getCodes().stream().forEach(code -> {
            switch (code) {
                case 1001: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryMiddlewareConfigDictionary(StringUtils.isNotEmpty((CharSequence)dictionaryParam.getNameEn()) ? dictionaryParam.getNameEn() : MachineRegionEnum.CN_MACHINE.getEn()));
                    break;
                }
                case 1002: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryResourceDictionary());
                    break;
                }
                case 1003: {
                    dictionaryDTO.put(code, this.queryAllRocketMqTopic(dictionaryParam.getMiddlewareId()));
                    break;
                }
                case 1004: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryAppType());
                    break;
                }
                case 1005: {
                    dictionaryDTO.put(code, this.queryStoreTailByEnName(dictionaryParam.getNameEn()));
                    break;
                }
                case 1006: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryMachineRegion());
                    break;
                }
                case 1007: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryDeployWay());
                    break;
                }
                case 1008: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryResourceTypeDictionary());
                    break;
                }
                case 1009: {
                    dictionaryDTO.put(code, this.queryLogStorageTypeDictionary());
                    break;
                }
                case 1010: {
                    dictionaryDTO.put(code, this.dictionaryExtensionService.queryMQDictionary());
                }
            }
        });
        log.debug("return val\uff1a{}", (Object)new Gson().toJson((Object)dictionaryDTO));
        return Result.success((Object)dictionaryDTO);
    }

    private List queryLogStorageTypeDictionary() {
        return Arrays.stream(LogStorageTypeEnum.values()).map(data -> {
            DictionaryDTO<String> dictionaryDTO = new DictionaryDTO<String>();
            dictionaryDTO.setLabel(data.name());
            dictionaryDTO.setValue(data.name().toLowerCase());
            return dictionaryDTO;
        }).collect(Collectors.toList());
    }

    private List<DictionaryDTO<?>> queryStoreTailByEnName(String nameEn) {
        ArrayList dictionaryDTOS = Lists.newArrayList();
        List<MilogLogTailDo> milogLogtailDos = this.dictionaryExtensionService.querySpecialTails();
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            List<Long> storedIds = milogLogtailDos.stream().filter(milogLogtailDo -> milogLogtailDo.getMotorRooms().stream().map(MotorRoomDTO::getNameEn).collect(Collectors.toList()).contains(nameEn)).map(MilogLogTailDo::getStoreId).collect(Collectors.toList());
            storedIds.forEach(storeId -> {
                MilogLogStoreDO milogLogstoreDO = this.milogLogstoreDao.queryById((Long)storeId);
                DictionaryDTO<Long> dictionaryDTO = new DictionaryDTO<Long>();
                dictionaryDTO.setLabel(milogLogstoreDO.getLogstoreName());
                dictionaryDTO.setValue(milogLogstoreDO.getId());
                dictionaryDTO.setChildren(this.queryTailByStore(milogLogtailDos, (Long)storeId, nameEn));
                dictionaryDTOS.add(dictionaryDTO);
            });
        }
        return dictionaryDTOS;
    }

    private List<DictionaryDTO<?>> queryTailByStore(List<MilogLogTailDo> milogLogtailDos, Long storeId, String nameEn) {
        ArrayList dictionaryDTOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            milogLogtailDos = milogLogtailDos.stream().filter(milogLogtailDo -> storeId.equals(milogLogtailDo.getStoreId())).filter(milogLogtailDo -> milogLogtailDo.getMotorRooms().stream().map(MotorRoomDTO::getNameEn).collect(Collectors.toList()).contains(nameEn)).collect(Collectors.toList());
            milogLogtailDos.forEach(milogLogtailDo -> {
                DictionaryDTO<Long> dictionaryDTO = new DictionaryDTO<Long>();
                dictionaryDTO.setLabel(milogLogtailDo.getTail());
                dictionaryDTO.setValue(milogLogtailDo.getId());
                dictionaryDTOS.add(dictionaryDTO);
            });
        }
        return dictionaryDTOS;
    }

    @Override
    public Result<String> downLoadFile() {
        File file = new File("D:\\work\\rocketmq.log");
        String str = "";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Result<String> fixLogTailMilogAppId(String appName) {
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryTailByAppName(appName);
        log.info("Synchronously repair tail's milogAppId, with {} entries", (Object)milogLogtailDos.size());
        int count = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (MilogLogTailDo milogLogtailDo : milogLogtailDos) {
            log.info("Start synchronizing the {} article of the tail, and there are {} articles left", (Object)(++count), (Object)(milogLogtailDos.size() - count));
            if (null != milogLogtailDo.getMilogAppId()) continue;
        }
        stopwatch.stop();
        log.info("Synchronously repair tail's milogAppId, which takes time: {} s", (Object)stopwatch.elapsed().getSeconds());
        return Result.success();
    }

    private List<DictionaryDTO<?>> queryAllRocketMqTopic(Long middlewareId) {
        MilogMiddlewareConfig middlewareConfig = this.milogMiddlewareConfigDao.queryById(middlewareId);
        List<DictionaryDTO> dictionaryDTOS = this.dictionaryExtensionService.queryExistsTopic(middlewareConfig.getAk(), middlewareConfig.getSk(), middlewareConfig.getNameServer(), middlewareConfig.getServiceUrl(), middlewareConfig.getAuthorization(), middlewareConfig.getOrgId(), middlewareConfig.getTeamId());
        Set existTopics = dictionaryDTOS.stream().map(dictionaryDTO -> dictionaryDTO.getValue().toString()).collect(Collectors.toSet());
        ArrayList dictionaryDTOList = Lists.newArrayList();
        existTopics.stream().map(s -> dictionaryDTOList.add(DictionaryDTO.Of(s, s)));
        return dictionaryDTOList;
    }
}

