/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.model.meta.AppLogMeta;
import org.apache.ozhera.log.api.model.meta.LogCollectMeta;
import org.apache.ozhera.log.api.model.meta.LogPattern;
import org.apache.ozhera.log.manager.dao.MilogAppTopicRelDao;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.service.MiLogMetaManageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MiLogMetaManageServiceImpl
implements MiLogMetaManageService {
    private static final Logger log = LoggerFactory.getLogger(MiLogMetaManageServiceImpl.class);
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private MilogAppTopicRelDao milogAppTopicRelDao;

    @Override
    public LogCollectMeta queryLogCollectMeta(String agentId, String agentIp) {
        ArrayList appIdList = Lists.newArrayList();
        Map<Long, List<MilogLogTailDo>> miLogTailMap = this.milogLogtailDao.getMilogLogtailByAppId(appIdList);
        LogCollectMeta meta = new LogCollectMeta();
        meta.setAgentId(agentId);
        meta.setAgentIp(agentIp);
        meta.setAgentMachine(null);
        ArrayList<AppLogMeta> metaList = new ArrayList<AppLogMeta>();
        for (Map.Entry<Long, List<MilogLogTailDo>> entry : miLogTailMap.entrySet()) {
            AppLogMeta appLogMeta = new AppLogMeta();
            appLogMeta.setAppId(entry.getKey());
            appLogMeta.setAppName(null);
            ArrayList<LogPattern> logPatternList = new ArrayList<LogPattern>();
            for (MilogLogTailDo milogLogtail : entry.getValue()) {
                LogPattern logPattern = new LogPattern();
                logPattern.setLogtailId(milogLogtail.getId());
                logPattern.setLogType(milogLogtail.getParseType());
                logPatternList.add(logPattern);
            }
            appLogMeta.setLogPatternList(logPatternList);
            metaList.add(appLogMeta);
        }
        meta.setAppLogMetaList(metaList);
        return meta;
    }
}

