/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.model.vo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class LogQuery
implements Serializable {
    private String logstore;
    private Long storeId;
    private String tail;
    private List<Long> tailIds;
    private Long startTime;
    private Long endTime;
    private Integer pageSize;
    private Integer page;
    private Object[] beginSortValue;
    private String fullTextSearch;
    private String sortKey = "timestamp";
    private Boolean asc = false;
    private Long[] appIds;
    private String statField;

    public LogQuery() {
    }

    public LogQuery(String logstore, Long storeId, String tail, Long startTime, Long endTime, String fullTextSearch, String sortKey) {
        this.logstore = logstore;
        this.storeId = storeId;
        this.tail = tail;
        this.startTime = startTime;
        this.endTime = endTime;
        this.fullTextSearch = fullTextSearch;
        this.sortKey = sortKey;
    }

    public LogQuery(String logstore, String tail, Long startTime, Long endTime, String fullTextSearch, String sortKey, Long[] appIds) {
        this.logstore = logstore;
        this.tail = tail;
        this.startTime = startTime;
        this.endTime = endTime;
        this.fullTextSearch = fullTextSearch;
        this.sortKey = sortKey;
        this.appIds = appIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogQuery logQuery = (LogQuery)o;
        return Objects.equals(this.logstore, logQuery.logstore) && Objects.equals(this.tail, logQuery.tail) && Objects.equals(this.startTime, logQuery.startTime) && Objects.equals(this.endTime, logQuery.endTime) && Objects.equals(this.pageSize, logQuery.pageSize) && Arrays.equals(this.beginSortValue, logQuery.beginSortValue) && Objects.equals(this.fullTextSearch, logQuery.fullTextSearch) && Objects.equals(this.sortKey, logQuery.sortKey) && Objects.equals(this.asc, logQuery.asc) && Arrays.equals((Object[])this.appIds, (Object[])logQuery.appIds);
    }

    public int hashCode() {
        int result = Objects.hash(this.logstore, this.tail, this.startTime, this.endTime, this.pageSize, this.fullTextSearch, this.sortKey, this.asc);
        result = 31 * result + Arrays.hashCode(this.beginSortValue);
        result = 31 * result + Arrays.hashCode((Object[])this.appIds);
        return result;
    }

    public String getLogstore() {
        return this.logstore;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public String getTail() {
        return this.tail;
    }

    public List<Long> getTailIds() {
        return this.tailIds;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPage() {
        return this.page;
    }

    public Object[] getBeginSortValue() {
        return this.beginSortValue;
    }

    public String getFullTextSearch() {
        return this.fullTextSearch;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public Boolean getAsc() {
        return this.asc;
    }

    public Long[] getAppIds() {
        return this.appIds;
    }

    public String getStatField() {
        return this.statField;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public void setTailIds(List<Long> tailIds) {
        this.tailIds = tailIds;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setBeginSortValue(Object[] beginSortValue) {
        this.beginSortValue = beginSortValue;
    }

    public void setFullTextSearch(String fullTextSearch) {
        this.fullTextSearch = fullTextSearch;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public void setAsc(Boolean asc) {
        this.asc = asc;
    }

    public void setAppIds(Long[] appIds) {
        this.appIds = appIds;
    }

    public void setStatField(String statField) {
        this.statField = statField;
    }

    public String toString() {
        return "LogQuery(logstore=" + this.getLogstore() + ", storeId=" + this.getStoreId() + ", tail=" + this.getTail() + ", tailIds=" + String.valueOf(this.getTailIds()) + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", pageSize=" + this.getPageSize() + ", page=" + this.getPage() + ", beginSortValue=" + Arrays.deepToString(this.getBeginSortValue()) + ", fullTextSearch=" + this.getFullTextSearch() + ", sortKey=" + this.getSortKey() + ", asc=" + this.getAsc() + ", appIds=" + Arrays.deepToString(this.getAppIds()) + ", statField=" + this.getStatField() + ")";
    }
}

