/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.controller.interceptor;

import com.google.common.collect.Sets;
import com.xiaomi.hera.trace.context.TraceIdUtil;
import com.xiaomi.mone.tpc.login.filter.DoceanReqUserFilter;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.aop.AopContext;
import com.xiaomi.youpin.docean.aop.EnhanceInterceptor;
import com.xiaomi.youpin.docean.mvc.ContextHolder;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.domain.Tpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HttpRequestInterceptor
extends EnhanceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestInterceptor.class);
    @Resource
    private DoceanReqUserFilter doceanReqUserFilter;
    private static final Integer MAX_LENGTH = 3000;
    private String filterUrls = Config.ins().get("filter_urls", "");
    private static final Set<String> TPC_HEADERS_URLS = Sets.newHashSet();
    private List<String> filterUrlList = Arrays.stream(this.filterUrls.split(",")).distinct().collect(Collectors.toList());

    public HttpRequestInterceptor() {
        TPC_HEADERS_URLS.add("/milog/space/getbypage");
        this.doceanReqUserFilter = new DoceanReqUserFilter();
        Config config = Config.ins();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("devMode", config.get("tpc.devMode", "false"));
        map.put("innerAuth", "false");
        map.put("authTokenUrl", config.get("auth_token_url", "http://127.0.0.1:8098/login/token/parse"));
        map.put("IGNORE_URL", "/alert/get");
        map.put("loginUrl", config.get("tpc_login_url", ""));
        map.put("logoutUrl", config.get("tpc_logout_url", ""));
        this.doceanReqUserFilter.init(map);
    }

    public void before(AopContext aopContext, Method method, Object[] args) {
        if (this.filterUrlList.contains(method.getName())) {
            return;
        }
        MvcContext mvcContext = ContextHolder.getContext().get();
        this.saveUserInfoThreadLocal(mvcContext);
    }

    private void saveUserInfoThreadLocal(MvcContext mvcContext) {
        AuthUserVo userVo = (AuthUserVo)mvcContext.session().getAttribute("TPC_USER");
        if (null == userVo && !this.doceanReqUserFilter.doFilter(mvcContext)) {
            throw new MilogManageException("please go to login");
        }
        userVo = (AuthUserVo)mvcContext.session().getAttribute("TPC_USER");
        Tpc tpc = (Tpc)Ioc.ins().getBean(Tpc.class);
        MoneUserContext.setCurrentUser(userVo, tpc.isAdmin(userVo.getAccount(), userVo.getUserType()));
    }

    public Object after(AopContext context, Method method, Object res) {
        this.solveResHeaders();
        this.clearThreadLocal();
        return super.after(context, method, res);
    }

    private void solveResHeaders() {
        MvcContext mvcContext = ContextHolder.getContext().get();
        mvcContext.getResHeaders().put("traceId", TraceIdUtil.traceId() == null ? "" : TraceIdUtil.traceId());
        if (TPC_HEADERS_URLS.contains(mvcContext.getPath())) {
            mvcContext.getResHeaders().put("tpc_home_url_head", Config.ins().get("tpc_home_url_head", "https://127.0.0.1"));
        }
    }

    public void exception(AopContext context, Method method, Throwable ex) {
        log.error("data exception,", ex);
        this.clearThreadLocal();
        super.exception(context, method, ex);
    }

    private void clearThreadLocal() {
        MoneUserContext.clear();
    }
}

