/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.validation;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Component;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.model.vo.MiLogMoneEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class OpenSourceValid {
    private static final Logger log = LoggerFactory.getLogger(OpenSourceValid.class);

    public String validMiLogMoneEnv(MiLogMoneEnv logMoneEnv) {
        ArrayList errorInfos = Lists.newArrayList();
        if (null == logMoneEnv.getNewAppId() || null == logMoneEnv.getOldAppId()) {
            errorInfos.add("appId Cannot be empty");
        }
        if (null == logMoneEnv.getNewEnvId() || null == logMoneEnv.getOldEnvId()) {
            errorInfos.add("envId Cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)logMoneEnv.getNewAppName()) || StringUtils.isBlank((CharSequence)logMoneEnv.getOldAppName())) {
            errorInfos.add("appName Cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)logMoneEnv.getNewEnvName()) || StringUtils.isBlank((CharSequence)logMoneEnv.getOldEnvName())) {
            errorInfos.add("envName Cannot be empty");
        }
        return errorInfos.stream().collect(Collectors.joining(","));
    }
}

