/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.utils;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.plugin.nacos.NacosConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Config;

public class ManagerUtil {
    private static final List<String> IGNORE_KEYS = Lists.newArrayList((Object[])new String[]{"keyword", "text", "ip", "date"});
    private static final String TAIL_KEY = "tail";
    public static final String DEFAULT_SERVER_TYPE = "open";

    private ManagerUtil() {
    }

    public static List<String> getKeyList(String keys, String columnTypes) {
        String[] keyDescryArray = keys.split(",");
        String[] keyTypeArray = columnTypes.split(",");
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i = 0; i < keyDescryArray.length; ++i) {
            if (!IGNORE_KEYS.contains(keyTypeArray[i].toLowerCase())) continue;
            keyList.add(keyDescryArray[i].split(":")[0]);
        }
        if (!keyList.contains(TAIL_KEY)) {
            keyList.add(TAIL_KEY);
        }
        return keyList;
    }

    public static List<String> getKeyColonPrefix(String keys) {
        String[] keyDescryArray = keys.split(",");
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i = 0; i < keyDescryArray.length; ++i) {
            keyList.add(keyDescryArray[i].split(":")[0]);
        }
        return keyList;
    }

    public static String MatchKVPrefix(String message, List<String> keyPerfixList) {
        String[] messageSplitArr = message.split(":");
        if (messageSplitArr.length != 2) {
            return "";
        }
        for (String keyPrefix : keyPerfixList) {
            if (!messageSplitArr[0].trim().equals(keyPrefix)) continue;
            return String.format("%s%s", keyPrefix, ":");
        }
        return "";
    }

    public static void getConfigFromNanos() {
        NacosConfig nacosConfig = new NacosConfig();
        nacosConfig.setDataId(Config.ins().get("nacos_config_dataid", ""));
        nacosConfig.setGroup(Config.ins().get("nacos_config_group", "DEFAULT_GROUP"));
        nacosConfig.setServerAddr(Config.ins().get("nacos_config_server_addr", ""));
        nacosConfig.init();
        nacosConfig.forEach((k, v) -> Config.ins().set(k, v));
    }

    public static String getPhysicsDirectory(String logPath) {
        String serverType = Config.ins().get("server.type", DEFAULT_SERVER_TYPE);
        if (StringUtils.equals((CharSequence)DEFAULT_SERVER_TYPE, (CharSequence)serverType)) {
            return "";
        }
        String[] splitPath = StringUtils.split((String)logPath, (String)"/");
        if (splitPath.length > 2) {
            return splitPath[splitPath.length - 2].trim();
        }
        return logPath.trim();
    }

    public static boolean isOpenEnv() {
        return StringUtils.equals((CharSequence)DEFAULT_SERVER_TYPE, (CharSequence)Config.ins().get("server.type", DEFAULT_SERVER_TYPE));
    }
}

