/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceInfo {
    @Expose(serialize=false, deserialize=false)
    private String jsonFromServer = "";
    public static final String SPLITER = "@@";
    private String name;
    private String groupName;
    private String clusters;
    private long cacheMillis = 1000L;
    @SerializedName(value="hosts")
    private List<Instance> hosts = new ArrayList<Instance>();
    private long lastRefTime = 0L;
    private String checksum = "";
    private volatile boolean allIPs = false;
    private static final String EMPTY = "";
    private static final String ALL_IPS = "000--00-ALL_IPS--00--000";

    public ServiceInfo() {
    }

    public boolean isAllIPs() {
        return this.allIPs;
    }

    public void setAllIPs(boolean allIPs) {
        this.allIPs = allIPs;
    }

    public ServiceInfo(String key) {
        int maxIndex = 2;
        int clusterIndex = 1;
        int serviceNameIndex = 0;
        String[] keys = key.split(SPLITER);
        if (keys.length >= maxIndex) {
            this.name = keys[serviceNameIndex];
            this.clusters = keys[clusterIndex];
        }
        this.name = keys[0];
    }

    public ServiceInfo(String name, String clusters) {
        this.name = name;
        this.clusters = clusters;
    }

    public int ipCount() {
        return this.hosts.size();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastRefTime > this.cacheMillis;
    }

    public void setHosts(List<Instance> hosts) {
        this.hosts = hosts;
    }

    public boolean isValid() {
        return this.hosts != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setLastRefTime(long lastRefTime) {
        this.lastRefTime = lastRefTime;
    }

    public long getLastRefTime() {
        return this.lastRefTime;
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public long getCacheMillis() {
        return this.cacheMillis;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    public List<Instance> getHosts() {
        return new ArrayList<Instance>(this.hosts);
    }

    public boolean validate() {
        if (this.isAllIPs()) {
            return true;
        }
        ArrayList<Instance> validHosts = new ArrayList<Instance>();
        for (Instance host : this.hosts) {
            if (!host.isHealthy()) continue;
            int i = 0;
            while ((double)i < host.getWeight()) {
                validHosts.add(host);
                ++i;
            }
        }
        return true;
    }

    public String getJsonFromServer() {
        return this.jsonFromServer;
    }

    public void setJsonFromServer(String jsonFromServer) {
        this.jsonFromServer = jsonFromServer;
    }

    public String getKey() {
        return ServiceInfo.getKey(this.name, this.clusters);
    }

    public String getKeyEncoded() {
        try {
            return ServiceInfo.getKey(URLEncoder.encode(this.name, "UTF-8"), this.clusters);
        }
        catch (UnsupportedEncodingException e) {
            return this.getKey();
        }
    }

    public static ServiceInfo fromKey(String key) {
        ServiceInfo serviceInfo = new ServiceInfo();
        int maxSegCount = 3;
        String[] segs = key.split(SPLITER);
        if (segs.length == maxSegCount - 1) {
            serviceInfo.setGroupName(segs[0]);
            serviceInfo.setName(segs[1]);
        } else if (segs.length == maxSegCount) {
            serviceInfo.setGroupName(segs[0]);
            serviceInfo.setName(segs[1]);
            serviceInfo.setClusters(segs[2]);
        }
        return serviceInfo;
    }

    public static String getKey(String name, String clusters) {
        if (!ServiceInfo.isEmpty(clusters)) {
            return name + SPLITER + clusters;
        }
        return name;
    }

    public String toString() {
        return this.getKey();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static boolean strEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    private static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }
}

