/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus;

import com.xiaomi.youpin.docean.plugin.mybatisplus.MybatisTransaction;
import java.sql.Connection;
import org.apache.ibatis.session.SqlSession;
import org.springframework.core.NamedThreadLocal;

public class TransactionalContext {
    private static ThreadLocal<TransactionalContext> context = new ThreadLocal<TransactionalContext>(){

        @Override
        protected TransactionalContext initialValue() {
            return new TransactionalContext();
        }
    };
    private MybatisTransaction jdbcTransaction;
    private static ThreadLocal<SqlSession> transactionSqlSession = new NamedThreadLocal("transactionSqlSession");
    private static ThreadLocal<Connection> connection = new NamedThreadLocal("connection");
    private static ThreadLocal<Boolean> transactionActive = new NamedThreadLocal("transactionActive");

    public void set(MybatisTransaction transaction) {
        this.jdbcTransaction = transaction;
    }

    public MybatisTransaction get() {
        return this.jdbcTransaction;
    }

    public static TransactionalContext getContext() {
        return context.get();
    }

    public void close() {
        context.remove();
        transactionSqlSession.remove();
        connection.remove();
        transactionActive.remove();
    }

    public static SqlSession getSqlSession() {
        return transactionSqlSession.get();
    }

    public static void setSqlSession(SqlSession sqlSession) {
        transactionSqlSession.set(sqlSession);
    }

    public static Connection getConnection() {
        return connection.get();
    }

    public static void setConnection(Connection conn) {
        connection.set(conn);
    }

    public static Boolean getTransactionActive() {
        return transactionActive.get();
    }

    public static void setTransactionActive(Boolean f) {
        transactionActive.set(f);
    }
}

