/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.uds.codes;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import com.xiaomi.data.push.uds.codes.DefaultHessian2FactoryInitializer;
import com.xiaomi.data.push.uds.codes.ICodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HessianCodes
implements ICodes {
    private static final Logger log = LoggerFactory.getLogger(HessianCodes.class);

    @Override
    public <T> T decode(byte[] data, Type type) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        Hessian2Input hi = new Hessian2Input((InputStream)is);
        hi.setSerializerFactory(DefaultHessian2FactoryInitializer.getSerializerFactory());
        try {
            Object object = hi.readObject();
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                hi.close();
                is.close();
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    @Override
    public <T> byte[] encode(T t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output ho = new Hessian2Output((OutputStream)os);
        ho.setSerializerFactory(DefaultHessian2FactoryInitializer.getSerializerFactory());
        try {
            ho.writeObject(t);
            ho.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ho.close();
                os.close();
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    @Override
    public byte type() {
        return 1;
    }
}

