/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.util.prometheus;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Sets;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.xiaomi.youpin.prometheus.client.binder.ClassLoaderMetricsReduced;
import com.xiaomi.youpin.prometheus.client.binder.JvmGcMetricsReduced;
import com.xiaomi.youpin.prometheus.client.binder.JvmMemoryMetricsReduced;
import com.xiaomi.youpin.prometheus.client.binder.JvmThreadMetricsReduced;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.consumer.DataCacheService;
import org.apache.ozhera.trace.etl.consumer.EnterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HTTPServer {
    private static final Logger log = LoggerFactory.getLogger(HTTPServer.class);
    @Value(value="${prometheus.http.server.port}")
    private int port;
    @NacosValue(value="${prometheus.token}")
    private String token;
    @Value(value="${security.scanner.ua}")
    private String ua;
    @Value(value="${app.name}")
    private String appName;
    @Value(value="${metrics.uri.whitelist}")
    private String uriWhitelist;
    @Resource
    private DataCacheService dataCacheService;
    @Resource
    private EnterManager enterManager;
    private HttpServer server;
    private ExecutorService executorService;
    public static final String APPLICATION = "application";

    @PostConstruct
    public void init() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 3);
            if (this.server == null || this.server.getAddress() == null) {
                throw new IllegalArgumentException("HttpServer hasn't been bound to an address");
            }
            HashMap<String, CollectorRegistry> handleMap = new HashMap<String, CollectorRegistry>();
            handleMap.put("default", CollectorRegistry.defaultRegistry);
            PrometheusMeterRegistry jvmRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            jvmRegistry.config().commonTags(new String[]{APPLICATION, this.appName});
            this.bindJvm(jvmRegistry);
            handleMap.put("jvm", jvmRegistry.getPrometheusRegistry());
            HTTPMetricHandler mHandler = new HTTPMetricHandler(handleMap);
            this.server.createContext("/", mHandler);
            this.server.createContext("/metrics", mHandler);
            this.server.createContext("/-/healthy", mHandler);
            this.executorService = Executors.newFixedThreadPool(5, NamedDaemonThreadFactory.defaultThreadFactory(false));
            this.server.setExecutor(this.executorService);
            this.start(false);
        }
        catch (Exception e) {
            log.error("http server start fail\uff1a", (Throwable)e);
        }
    }

    protected static String getToken(String query) throws IOException {
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1 || !"token".equals(URLDecoder.decode(pair.substring(0, idx), "UTF-8"))) continue;
                return URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
            }
        }
        return null;
    }

    private void bindJvm(PrometheusMeterRegistry jvmRegistry) {
        new ClassLoaderMetricsReduced().bindTo((MeterRegistry)jvmRegistry);
        new JvmMemoryMetricsReduced().bindTo((MeterRegistry)jvmRegistry);
        new JvmGcMetricsReduced().bindTo((MeterRegistry)jvmRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)jvmRegistry);
        new JvmThreadMetricsReduced().bindTo((MeterRegistry)jvmRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)jvmRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)jvmRegistry);
    }

    private void start(boolean daemon) {
        if (daemon == Thread.currentThread().isDaemon()) {
            this.server.start();
        } else {
            FutureTask<Object> startTask = new FutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                    HTTPServer.this.server.start();
                }
            }, null);
            NamedDaemonThreadFactory.defaultThreadFactory(daemon).newThread(startTask).start();
            try {
                startTask.get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    class HTTPMetricHandler
    implements HttpHandler {
        private final Map<String, CollectorRegistry> registryMap;
        private final byte[] HEALTHY_RESPONSE = "ok".getBytes();
        private Map<String, byte[]> data = new ConcurrentHashMap<String, byte[]>();
        private Map<String, Long> uriLastTime = new ConcurrentHashMap<String, Long>();

        HTTPMetricHandler(Map<String, CollectorRegistry> registryMap) {
            this.registryMap = registryMap;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Map<String, Object> getData(String contentType, CollectorRegistry registry, String uri, String remoteAddr) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            long now = System.currentTimeMillis();
            String url = remoteAddr + uri;
            Long lastTime = this.uriLastTime.get(url);
            long lastTime1 = lastTime == null ? 0L : lastTime;
            boolean isCache = true;
            if (now - lastTime1 > 5000L) {
                isCache = false;
                this.uriLastTime.put(url, now);
                List<Object> list = new ArrayList();
                try {
                    Field field = registry.getClass().getDeclaredField("namesToCollectors");
                    field.setAccessible(true);
                    Map namesToCollectors = (Map)field.get(registry);
                    list = namesToCollectors.keySet().stream().filter(it -> !it.endsWith("created")).collect(Collectors.toList());
                }
                catch (Exception e) {
                    log.info("export metrics error : ", (Throwable)e);
                }
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    HashMap<String, Object> hashMap;
                    try (OutputStreamWriter writer = new OutputStreamWriter(baos);){
                        TextFormat.writeFormat((String)contentType, (Writer)writer, (Enumeration)registry.filteredMetricFamilySamples((Set)Sets.newHashSet(list)));
                        writer.flush();
                        byte[] bytes = baos.toByteArray();
                        this.data.put(url, bytes);
                        result.put("data", bytes);
                        result.put("isCache", isCache);
                        hashMap = result;
                    }
                    return hashMap;
                }
                catch (Throwable ex) {
                    log.error("httpserver getdata error:", ex);
                    result.put("data", new byte[0]);
                    result.put("isCache", isCache);
                    return result;
                }
            }
            result.put("data", this.data.get(url));
            result.put("isCache", isCache);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String query;
            long a = System.currentTimeMillis();
            if (!this.filterRequest(exchange)) {
                return;
            }
            String hostString = exchange.getRemoteAddress().getHostString();
            String path = exchange.getRequestURI().getPath();
            byte[] data = null;
            try {
                try (OutputStream os = exchange.getResponseBody();){
                    if ("/-/healthy".equals(path)) {
                        exchange.sendResponseHeaders(200, this.HEALTHY_RESPONSE.length);
                        os.write(this.HEALTHY_RESPONSE);
                        os.flush();
                    } else {
                        String acceptHeader = exchange.getRequestHeaders().getFirst("Accept");
                        log.info("prometheus pull header is : " + acceptHeader);
                        String contentType = TextFormat.chooseContentType((String)acceptHeader);
                        exchange.getResponseHeaders().set("Content-Type", contentType);
                        if ("/jvm".equals(path)) {
                            CollectorRegistry registry = this.registryMap.get("jvm");
                            Map<String, Object> dataMap = this.getData(contentType, registry, path, hostString);
                            data = (byte[])dataMap.get("data");
                        } else {
                            data = HTTPServer.this.dataCacheService.isStartCache() ? HTTPServer.this.dataCacheService.getData() : this.firstPull();
                        }
                        exchange.sendResponseHeaders(200, data.length);
                        os.write(data);
                        os.flush();
                    }
                }
                query = exchange.getRequestURI().getRawQuery();
            }
            catch (Throwable ex) {
                String query2;
                try {
                    ex.printStackTrace();
                    exchange.sendResponseHeaders(200, 0L);
                    exchange.getResponseBody().write(new byte[0]);
                    query2 = exchange.getRequestURI().getRawQuery();
                }
                catch (Throwable throwable) {
                    String query3 = exchange.getRequestURI().getRawQuery();
                    long b = System.currentTimeMillis();
                    int len = null != data ? data.length : 0;
                    log.info("prometheus request uri : " + path + " queryString : " + query3 + " remoteAddr\uff1a" + hostString + " duration : " + (b - a) + " data size:" + len);
                    throw throwable;
                }
                long b = System.currentTimeMillis();
                int len = null != data ? data.length : 0;
                log.info("prometheus request uri : " + path + " queryString : " + query2 + " remoteAddr\uff1a" + hostString + " duration : " + (b - a) + " data size:" + len);
            }
            long b = System.currentTimeMillis();
            int len = null != data ? data.length : 0;
            log.info("prometheus request uri : " + path + " queryString : " + query + " remoteAddr\uff1a" + hostString + " duration : " + (b - a) + " data size:" + len);
        }

        private byte[] firstPull() {
            try {
                HTTPServer.this.enterManager.getMonitor().enter();
                while (HTTPServer.this.enterManager.getProcessNum().get() > 0) {
                    TimeUnit.MILLISECONDS.sleep(200L);
                }
                byte[] byArray = HTTPServer.this.dataCacheService.cacheDataSync();
                return byArray;
            }
            catch (Throwable ex) {
                log.error("first pull error", ex);
            }
            finally {
                HTTPServer.this.dataCacheService.setStartCache(true);
                HTTPServer.this.enterManager.getMonitor().leave();
            }
            return null;
        }

        private boolean filterRequest(HttpExchange exchange) {
            String path;
            Object headers;
            if (StringUtils.isEmpty((CharSequence)HTTPServer.this.ua)) {
                return true;
            }
            Headers requestHeaders = exchange.getRequestHeaders();
            if (requestHeaders != null && requestHeaders.size() > 0 && (headers = requestHeaders.get("User-agent")) != null && headers.size() > 0) {
                Iterator iterator = headers.iterator();
                while (iterator.hasNext()) {
                    String header = (String)iterator.next();
                    for (String uaBlack : HTTPServer.this.ua.split(";")) {
                        if (!header.contains(uaBlack)) continue;
                        return false;
                    }
                }
            }
            return !StringUtils.isEmpty((CharSequence)(path = exchange.getRequestURI().getPath())) && HTTPServer.this.uriWhitelist.contains(path);
        }
    }

    static class NamedDaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final int poolNumber = POOL_NUMBER.getAndIncrement();
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadFactory delegate;
        private final boolean daemon;

        NamedDaemonThreadFactory(ThreadFactory delegate, boolean daemon) {
            this.delegate = delegate;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.delegate.newThread(r);
            t.setName(String.format("prometheus-http-%d-%d", this.poolNumber, this.threadNumber.getAndIncrement()));
            t.setDaemon(this.daemon);
            return t;
        }

        static ThreadFactory defaultThreadFactory(boolean daemon) {
            return new NamedDaemonThreadFactory(Executors.defaultThreadFactory(), daemon);
        }
    }
}

