/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.util.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.NacosNamingService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NacosClientUtil {
    private static final Logger log = LoggerFactory.getLogger(NacosClientUtil.class);
    @NacosValue(value="${nacos.address}")
    private String nacosAddr;
    @Value(value="${prometheus.http.server.port}")
    private int prometheusPort;
    private ConfigService nacosConfigService;
    private String serverIp = System.getenv("CONTAINER_S_IP");
    private String hostName = System.getenv("CONTAINER_S_HOSTNAME");

    @PostConstruct
    public void registNacos() {
        try {
            Properties properties = new Properties();
            properties.put("serverAddr", this.nacosAddr);
            this.nacosConfigService = NacosFactory.createConfigService((Properties)properties);
            if (StringUtils.isEmpty((CharSequence)this.serverIp)) {
                this.serverIp = InetAddress.getLocalHost().getHostAddress();
            }
            List<NacosNamingService> nacos = this.getNacos();
            for (NacosNamingService nacosNamingService : nacos) {
                log.info("nacos regist prometheus port is : " + this.prometheusPort);
                Instance instance = new Instance();
                instance.setIp(this.serverIp);
                instance.setPort(55255);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("jaegerQuery_port", String.valueOf(this.prometheusPort));
                map.put("jaegerQuery_host_name", String.valueOf(this.hostName));
                instance.setMetadata(map);
                nacosNamingService.registerInstance("jaegerQuery_ip_port", instance);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    log.info("nacos shutdown hook deregister instance");
                    try {
                        nacosNamingService.deregisterInstance("jaegerQuery_ip_port", instance.getIp(), instance.getPort());
                    }
                    catch (Exception e) {
                        log.error("nacos shutdown hook error : " + e.getMessage());
                    }
                }));
            }
        }
        catch (Exception e) {
            log.error("register IP to nacos failed\uff1a", (Throwable)e);
        }
    }

    public List<NacosNamingService> getNacos() {
        ArrayList<NacosNamingService> list = new ArrayList<NacosNamingService>();
        try {
            NacosNamingService chinaNacosNamingService = new NacosNamingService(this.nacosAddr);
            list.add(chinaNacosNamingService);
        }
        catch (Exception e) {
            log.error("init NacosNamingService failed\uff1a", (Throwable)e);
        }
        return list;
    }
}

