/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file;

import com.google.common.collect.Lists;
import com.xiaomi.mone.file.LogFile;
import com.xiaomi.mone.file.MoneRandomAccessFile;
import com.xiaomi.mone.file.ReadEvent;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.ReadResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.MessageDigest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileWS
extends LogFile {
    private static final Logger log = LoggerFactory.getLogger(LogFileWS.class);
    private final String file;
    private MoneRandomAccessFile raf;
    private ReadListener listener;
    private volatile boolean stop;
    private volatile boolean reOpen;
    private long pointer;
    private long lineNumber;
    private String md5;
    private WatchService ws;

    public LogFileWS(String file, ReadListener listener) {
        super(file, listener);
        try {
            this.ws = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = this.readPointer();
    }

    public LogFileWS(String file, ReadListener listener, long pointer, long lineNumber) {
        super(file, listener, pointer, lineNumber);
        try {
            this.ws = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = pointer;
        this.lineNumber = lineNumber;
    }

    private void open() {
        try {
            this.raf = new MoneRandomAccessFile(this.file, "r", 512);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reOpen = false;
    }

    @Override
    public void readLine() throws IOException {
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Path p = Paths.get(this.file.substring(0, this.file.length() - 11), new String[0]);
        p.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        do {
            this.open();
            try {
                log.info("open file:{},pointer:{}", (Object)this.file, (Object)this.raf.getFilePointer());
                if (this.pointer > this.raf.length()) {
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                }
            }
            catch (Exception e) {
                log.error("file.length() IOException, file:{}", (Object)this.file, (Object)e);
            }
            this.raf.seek(this.pointer);
            block7: while (true) {
                WatchKey watchKey = null;
                try {
                    watchKey = watchService.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
                for (WatchEvent<?> watchEvent : watchEvents) {
                    if (!watchEvent.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY)) continue;
                    String line = this.raf.getNextLine();
                    if (null != line && (line = new String(line.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8)).length() > 1100000) {
                        line = line.substring(0, 1100000);
                    }
                    if (this.reOpen) {
                        this.pointer = 0L;
                        this.lineNumber = 0L;
                        break block7;
                    }
                    if (this.stop) break block7;
                    Long maxPointer = null;
                    try {
                        this.pointer = this.raf.getFilePointer();
                        maxPointer = this.raf.length();
                    }
                    catch (IOException e) {
                        log.error("file.length() IOException, file:{}", (Object)this.file, (Object)e);
                    }
                    ReadResult readResult = new ReadResult();
                    readResult.setLines(Lists.newArrayList((Object[])new String[]{line}));
                    readResult.setPointer(this.pointer);
                    readResult.setFileMaxPointer(maxPointer);
                    readResult.setLineNumber(++this.lineNumber);
                    ReadEvent event = new ReadEvent(readResult);
                    this.listener.onEvent(event);
                }
                watchKey.reset();
            }
            this.raf.close();
        } while (!this.stop);
    }

    @Override
    public void shutdown() {
        try {
            this.stop = true;
            Files.write(Paths.get("/tmp/" + this.md5, new String[0]), String.valueOf(this.pointer).getBytes(), new OpenOption[0]);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
        }
    }

    @Override
    public long readPointer() {
        try {
            byte[] data = Files.readAllBytes(Paths.get("/tmp/" + this.md5, new String[0]));
            return Long.valueOf(new String(data));
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return 0L;
        }
    }

    @Override
    public String md5(String msg) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(msg.getBytes());
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(2 * digest.length);
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString().toUpperCase();
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public void setReOpen(boolean reOpen) {
        this.reOpen = reOpen;
    }
}

