/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.es;

import com.xiaomi.mone.es.EsClient;
import com.xiaomi.mone.es.EsProcessor;
import com.xiaomi.mone.es.ProcessorConf;
import com.xiaomi.youpin.docean.plugin.es.EsProcessorConf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.IndexTemplateMetadata;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;

public class EsService {
    private EsClient esClient;

    public EsClient getEsClient() {
        return this.esClient;
    }

    public EsService(String esAddr, String token, String catalog, String database) {
        this.esClient = new EsClient(esAddr, token, catalog, database);
    }

    public EsService(String address, String useranme, String password) {
        this.esClient = new EsClient(address, useranme, password);
    }

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return this.esClient.search(searchRequest);
    }

    public void insertDoc(String index, Map<String, Object> data) throws IOException {
        this.esClient.insertDoc(index, data);
    }

    public void insertDocAsyn(String index, Map<String, Object> data, ActionListener<IndexResponse> listener) {
        this.esClient.insertDocAsyn(index, data, listener);
    }

    @Deprecated
    public boolean bulkInsertDoc(String index, List<Map<String, Object>> dataList) throws IOException {
        return this.esClient.bulkInsert(index, dataList);
    }

    public EsProcessor getEsProcessor(EsProcessorConf conf) {
        return new EsProcessor(new ProcessorConf(conf.getBulkActions(), conf.getByteSize(), conf.getConcurrentRequest(), conf.getFlushInterval(), conf.getRetryNumber(), conf.getRetryInterval(), this.esClient, conf.getListener()));
    }

    public void createIndex(String name, String mapping) throws IOException {
        this.esClient.createIndex(name, mapping);
    }

    public CreateIndexResponse createIndex(org.elasticsearch.action.admin.indices.create.CreateIndexRequest request) throws IOException {
        return this.esClient.createIndex(request);
    }

    public org.elasticsearch.client.indices.CreateIndexResponse createIndex(CreateIndexRequest request) throws IOException {
        return this.esClient.createIndex(request);
    }

    public GetResponse get(GetRequest request) throws IOException {
        return this.esClient.get(request);
    }

    public SearchResponse queryByIndex(String index) throws IOException {
        return this.esClient.queryByIndex(index);
    }

    public DeleteResponse delete(DeleteRequest request) throws IOException {
        return this.esClient.delete(request);
    }

    public UpdateResponse update(UpdateRequest request) throws IOException {
        return this.esClient.update(request);
    }

    public boolean createIndexTemplate(PutIndexTemplateRequest request) throws IOException {
        return this.esClient.createIndexTemplate(request);
    }

    public boolean existsTemplate(IndexTemplatesExistRequest request) throws IOException {
        return this.esClient.existsTemplate(request);
    }

    public List<IndexTemplateMetadata> getIndexTemplates(GetIndexTemplatesRequest request) throws IOException {
        return this.esClient.getIndexTemplates(request);
    }

    public EsClient.EsRet dateHistogram(String indexName, String interval, long startTime, long endTime, BoolQueryBuilder builder) throws IOException {
        return this.esClient.dateHistogram(indexName, interval, startTime, endTime, builder);
    }

    public EsClient.EsRet dateHistogram(String indexName, String field, String interval, long startTime, long endTime, BoolQueryBuilder builder) throws IOException {
        return this.esClient.dateHistogram(indexName, field, interval, startTime, endTime, builder);
    }

    public Long count(CountRequest countRequest) throws IOException {
        return this.esClient.count(countRequest);
    }

    public Integer getClusterHealth() throws IOException {
        return this.esClient.getClusterHealth();
    }

    public void searchAsync(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.esClient.searchAsync(searchRequest, listener);
    }
}

