/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.rocketmq;

import com.xiaomi.youpin.docean.anno.Service;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.parse.LogParserFactory;
import org.apache.ozhera.log.stream.common.SinkJobEnum;
import org.apache.ozhera.log.stream.job.LogDataTransfer;
import org.apache.ozhera.log.stream.job.SinkJobConfig;
import org.apache.ozhera.log.stream.job.extension.MessageSender;
import org.apache.ozhera.log.stream.job.extension.MessageSenderFactory;
import org.apache.ozhera.log.stream.job.extension.SinkJob;
import org.apache.ozhera.log.stream.job.extension.SinkJobProvider;
import org.apache.ozhera.log.stream.job.extension.rocketmq.RocketMqSinkJob;
import org.apache.ozhera.log.stream.job.extension.rocketmq.RocketmqConfig;
import org.apache.ozhera.log.stream.job.extension.rocketmq.RocketmqPlugin;
import org.apache.ozhera.log.stream.sink.SinkChain;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;

@Service(name="rocketmqSinkJobProvider")
public class RocketMqSinkJobProvider
implements SinkJobProvider {
    @Override
    public SinkJob getSinkJob(SinkJobConfig sinkJobConfig) {
        SinkJobEnum jobType = SinkJobEnum.valueOf(sinkJobConfig.getJobType());
        MessageSender messageSender = MessageSenderFactory.getMessageSender(sinkJobConfig);
        SinkChain sinkChain = sinkJobConfig.getSinkChain();
        LogParser logParser = LogParserFactory.getLogParser((Integer)sinkJobConfig.getParseType(), (String)sinkJobConfig.getKeyList(), (String)sinkJobConfig.getValueList(), (String)sinkJobConfig.getParseScript(), (String)sinkJobConfig.getTopic(), (String)sinkJobConfig.getTail(), (String)sinkJobConfig.getTag(), (String)sinkJobConfig.getLogStoreName());
        LogDataTransfer dataTransfer = new LogDataTransfer(sinkChain, logParser, messageSender, sinkJobConfig);
        dataTransfer.setJobType(jobType);
        RocketmqConfig rocketmqConfig = RocketmqPlugin.buildRocketmqConfig(sinkJobConfig.getAk(), sinkJobConfig.getSk(), sinkJobConfig.getClusterInfo(), sinkJobConfig.getTopic(), sinkJobConfig.getTag(), jobType);
        DefaultMQPushConsumer rocketMqConsumer = RocketmqPlugin.getRocketMqConsumer(rocketmqConfig);
        RocketMqSinkJob sinkJob = new RocketMqSinkJob(rocketmqConfig, rocketMqConsumer, dataTransfer);
        return sinkJob;
    }

    @Override
    public SinkJob getBackupJob(SinkJobConfig sinkJobConfig) {
        return null;
    }
}

