/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.failover;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.store.failover.FailoverCondition;

public abstract class StrategyMetadataReport
implements MetadataReport {
    protected URL url;
    protected static final String STRATEGY_KEY = "strategy";
    protected FailoverCondition strategy;
    protected ExtensionLoader<FailoverCondition> failoverLoader = ExtensionLoader.getExtensionLoader(FailoverCondition.class);

    public StrategyMetadataReport(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is required.");
        }
        this.url = url;
        this.createFailoverStrategy(url);
    }

    protected void createFailoverStrategy(URL url) {
        String strategy = url.getParameter(STRATEGY_KEY);
        if (strategy != null) {
            if (!this.failoverLoader.hasExtension(strategy)) {
                throw new IllegalArgumentException("No '" + strategy + "' failover condition extension found.");
            }
            this.strategy = this.failoverLoader.getExtension(strategy);
        }
    }

    protected boolean shouldRegister(URL url) {
        return this.strategy == null || this.strategy.shouldRegister(url);
    }

    protected boolean shouldQuery(URL url) {
        return this.strategy == null || this.strategy.shouldQuery(url);
    }

    protected boolean isLocalDataCenter(URL url) {
        return this.strategy == null || this.strategy.isLocalDataCenter(url);
    }
}

