/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractReferenceConfig;
import org.apache.dubbo.config.support.Parameter;

public class ConsumerConfig
extends AbstractReferenceConfig {
    private static final long serialVersionUID = 2827274711143680600L;
    private String client;
    private String threadpool;
    private Integer corethreads;
    private Integer threads;
    private Integer queues;
    private Integer shareconnections;
    private String urlMergeProcessor;

    @Override
    public void setTimeout(Integer timeout) {
        super.setTimeout(timeout);
        String rmiTimeout = System.getProperty("sun.rmi.transport.tcp.responseTimeout");
        if (timeout != null && timeout > 0 && StringUtils.isEmpty(rmiTimeout)) {
            System.setProperty("sun.rmi.transport.tcp.responseTimeout", String.valueOf(timeout));
        }
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getThreadpool() {
        return this.threadpool;
    }

    public void setThreadpool(String threadpool) {
        this.threadpool = threadpool;
    }

    public Integer getCorethreads() {
        return this.corethreads;
    }

    public void setCorethreads(Integer corethreads) {
        this.corethreads = corethreads;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public Integer getQueues() {
        return this.queues;
    }

    public void setQueues(Integer queues) {
        this.queues = queues;
    }

    public Integer getShareconnections() {
        return this.shareconnections;
    }

    public void setShareconnections(Integer shareconnections) {
        this.shareconnections = shareconnections;
    }

    @Parameter(key="url-merge-processor")
    public String getUrlMergeProcessor() {
        return this.urlMergeProcessor;
    }

    public void setUrlMergeProcessor(String urlMergeProcessor) {
        this.urlMergeProcessor = urlMergeProcessor;
    }
}

