/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.support.Parameter;

public class ConfigCenterConfig
extends AbstractConfig {
    private AtomicBoolean inited = new AtomicBoolean(false);
    private String protocol;
    private String address;
    private Integer port;
    private String cluster;
    private String namespace = "dubbo";
    private String group = "dubbo";
    private String username;
    private String password;
    private Long timeout = 3000L;
    private Boolean highestPriority = true;
    private Boolean check = true;
    private String configFile = "dubbo.properties";
    private String appConfigFile;
    private Map<String, String> parameters;
    private Map<String, String> externalConfiguration;
    private Map<String, String> appExternalConfiguration;

    public ConfigCenterConfig() {
    }

    public ConfigCenterConfig(String address) {
        this.setAddress(address);
    }

    public URL toUrl() {
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigCenterConfig.appendParameters(map, this);
        if (StringUtils.isEmpty(this.address)) {
            this.address = "0.0.0.0";
        }
        map.put("path", ConfigCenterConfig.class.getSimpleName());
        if (StringUtils.isEmpty((String)map.get("protocol"))) {
            map.put("protocol", "zookeeper");
        }
        return UrlUtils.parseURL(this.address, map);
    }

    public boolean checkOrUpdateInited() {
        return this.inited.compareAndSet(false, true);
    }

    public Map<String, String> getExternalConfiguration() {
        return this.externalConfiguration;
    }

    public Map<String, String> getAppExternalConfiguration() {
        return this.appExternalConfiguration;
    }

    public void setExternalConfig(Map<String, String> externalConfiguration) {
        this.externalConfiguration = externalConfiguration;
    }

    public void setAppExternalConfig(Map<String, String> appExternalConfiguration) {
        this.appExternalConfiguration = appExternalConfiguration;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Parameter(excluded=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (address != null) {
            try {
                URL url = URL.valueOf(address);
                this.setUsername(url.getUsername());
                this.setPassword(url.getPassword());
                this.updateIdIfAbsent(url.getProtocol());
                this.updateProtocolIfAbsent(url.getProtocol());
                this.updatePortIfAbsent(url.getPort());
                this.updateParameters(url.getParameters());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean isCheck() {
        return this.check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    @Parameter(key="highest-priority")
    public Boolean isHighestPriority() {
        return this.highestPriority;
    }

    public void setHighestPriority(Boolean highestPriority) {
        this.highestPriority = highestPriority;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Parameter(key="config-file")
    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Parameter(excluded=true, key="app-config-file")
    public String getAppConfigFile() {
        return this.appConfigFile;
    }

    public void setAppConfigFile(String appConfigFile) {
        this.appConfigFile = appConfigFile;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    @Parameter(excluded=true)
    public boolean isValid() {
        if (StringUtils.isEmpty(this.address)) {
            return false;
        }
        return this.address.contains("://") || StringUtils.isNotEmpty(this.protocol);
    }

    protected void updatePortIfAbsent(Integer value) {
        if (value != null && value > 0 && this.port == null) {
            this.port = value;
        }
    }

    protected void updateProtocolIfAbsent(String value) {
        if (StringUtils.isNotEmpty(value) && StringUtils.isEmpty(this.protocol)) {
            this.protocol = value;
        }
    }

    public void updateParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = parameters;
        } else {
            this.parameters.putAll(parameters);
        }
    }
}

