/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.error;

import com.google.gson.Gson;
import com.xiaomi.data.push.dao.mapper.ErrorRecordMapper;
import com.xiaomi.data.push.dao.model.ErrorRecordWithBLOBs;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorService {
    private static final Logger logger = LoggerFactory.getLogger(ErrorService.class);
    @Autowired
    private ErrorRecordMapper errorRecordMapper;
    private final long timeoutMillis = 100L;
    private Semaphore semaphore = new Semaphore(10);

    public void recordError(ErrorRecordWithBLOBs errorRecord) {
        block6: {
            try {
                boolean acquired = this.semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS);
                if (acquired) {
                    try {
                        this.errorRecordMapper.insert(errorRecord);
                        break block6;
                    }
                    finally {
                        this.semaphore.release();
                    }
                }
                String info = String.format("recordError tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", 100L, this.semaphore.getQueueLength(), this.semaphore.availablePermits());
                logger.warn(info + " error:{}", (Object)new Gson().toJson((Object)errorRecord));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

