/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.locator;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.conf.AgentTailConf;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineLocator;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineRpcLocator;
import org.apache.ozhera.log.agent.common.AbstractElementAdapter;
import org.apache.ozhera.log.agent.input.Input;
import org.apache.ozhera.log.agent.output.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDefineJsonLocator
implements ChannelDefineLocator {
    private static final Logger log = LoggerFactory.getLogger(ChannelDefineJsonLocator.class);
    private static Gson gson;

    @Override
    public List<ChannelDefine> getChannelDefine() {
        try {
            AgentTailConf agentTailConf = (AgentTailConf)gson.fromJson(this.readConfigJson(), new TypeToken<AgentTailConf>(this){}.getType());
            return ChannelDefineRpcLocator.agentTail2ChannelDefine(agentTailConf);
        }
        catch (Exception e) {
            log.error("ChannelDefineJsonLocator getChannelDefine exception:{}", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public List<ChannelDefine> getChannelDefine(String ip) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readConfigJson() {
        BufferedReader in = null;
        try {
            String str;
            String line;
            in = new BufferedReader(new InputStreamReader(ChannelDefineJsonLocator.class.getClassLoader().getResourceAsStream("agent_channel_config.json")));
            StringBuffer sb = new StringBuffer();
            while (null != (line = in.readLine())) {
                sb.append("\n" + line);
            }
            log.warn("ChannelDefineJsonLocator:{}", (Object)sb.toString());
            String string = str = sb.toString().replaceAll("\r|\n|\\s", "");
            return string;
        }
        catch (IOException e) {
            log.error("readConfigJson IOException:{}", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Input.class, (Object)new AbstractElementAdapter());
        gsonBuilder.registerTypeAdapter(Output.class, (Object)new AbstractElementAdapter());
        gson = gsonBuilder.create();
    }
}

