/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.aop;

import java.lang.reflect.Method;
import org.apache.ozhera.prometheus.agent.aop.ArgCheck;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.param.BaseParam;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMapping;

@Aspect
@Configuration
public class ArgCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(ArgCheckAspect.class);

    @Pointcut(value="@annotation(org.apache.ozhera.prometheus.agent.aop.ArgCheck)")
    public void argCheck() {
    }

    @Around(value="argCheck()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length <= 0) {
            return joinPoint.proceed();
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ArgCheck argCheck = method.getAnnotation(ArgCheck.class);
        RequestMapping reqMapping = method.getAnnotation(RequestMapping.class);
        Class<?> resultCls = method.getReturnType();
        for (Object arg : args) {
            if (!(arg instanceof org.apache.ozhera.prometheus.agent.param.ArgCheck)) continue;
            if (arg instanceof BaseParam) {
                BaseParam baseParam = (BaseParam)arg;
                log.info("\u63a5\u53e3{}\u8bf7\u6c42\u53c2\u6570{}", (Object)method.getName(), arg);
                if (!((org.apache.ozhera.prometheus.agent.param.ArgCheck)arg).argCheck()) {
                    log.warn("\u7528\u6237\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25; arg={}", arg);
                    return this.getResult(resultCls, ErrorCode.invalidParamError);
                }
            }
            try {
                Object result = joinPoint.proceed();
                log.info("\u63a5\u53e3{}\u8bf7\u6c42\u54cd\u5e94{}", (Object)method.getName(), result);
                return result;
            }
            catch (Throwable e) {
                log.error("\u63a5\u53e3{}\u8bf7\u6c42\u5f02\u5e38", (Object)method.getName(), (Object)e);
                return this.getResult(resultCls, ErrorCode.unknownError);
            }
        }
        try {
            Object result = joinPoint.proceed();
            log.info("\u63a5\u53e3{}\u8bf7\u6c42\u54cd\u5e94{}", (Object)method.getName(), result);
            return result;
        }
        catch (Throwable e) {
            log.error("\u63a5\u53e3{}\u8bf7\u6c42\u5f02\u5e38", (Object)method.getName(), (Object)e);
            return this.getResult(resultCls, ErrorCode.unknownError);
        }
    }

    private Object getResult(Class<?> resultCls, ErrorCode responseCode) {
        return responseCode;
    }
}

