/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.api.bo;

import java.io.Serializable;

public class Result<T>
implements Serializable {
    private int code;
    private T data;
    private String message;
    private static final int SUCCESS_CODE = 0;
    private static final int FAILURE_CODE = 500;

    public static <T> Result<T> fail(int code, String msg) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setMessage(msg);
        return result;
    }

    public static <T> Result<T> fail(String msg) {
        Result<T> result = new Result<T>();
        result.setCode(500);
        result.setMessage(msg);
        return result;
    }

    public static <T> Result<T> success(int code, T data) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setData(data);
        result.setMessage("success");
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<T>();
        result.setCode(0);
        result.setData(data);
        result.setMessage("success");
        return result;
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", data=" + String.valueOf(this.getData()) + ", message=" + this.getMessage() + ")";
    }
}

