/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy;

import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Map<String, String> getPropertiesFromFile(File file) {
        return this.loadProperties(file.toURI().toURL());
    }

    public Map<String, String> loadProperties(URL url) {
        Map map;
        try (InputStreamReader inReader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(inReader);
            map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public final void waitUntil(Function0<Object> checkForEvent, Duration atMost) throws TimeoutException, InterruptedException {
        long endTime = System.currentTimeMillis() + atMost.toMillis();
        this.aux$1(1, checkForEvent, endTime);
    }

    public boolean isProcessAlive(Process process) {
        boolean bl;
        try {
            process.exitValue();
            bl = false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Thread startDaemonThread(String name, Function0<BoxedUnit> f) {
        void var3_3;
        Thread thread = new Thread(name, f){
            private final Function0 f$1;

            public void run() {
                this.f$1.apply$mcV$sp();
            }
            {
                this.f$1 = f$1;
                super(name$1);
            }
        };
        thread.setDaemon(true);
        thread.start();
        return var3_3;
    }

    public <A extends Closeable, B> B usingResource(A resource, Function1<A, B> f) {
        Object object;
        try {
            object = f.apply(resource);
        }
        finally {
            resource.close();
        }
        return (B)object;
    }

    public String createSecret(int secretBitLength) {
        SecureRandom rnd = new SecureRandom();
        byte[] secretBytes = new byte[secretBitLength / 8];
        rnd.nextBytes(secretBytes);
        return Base64.encodeBase64String((byte[])secretBytes);
    }

    private final void aux$1(int count, Function0 checkForEvent$1, long endTime$1) {
        while (!checkForEvent$1.apply$mcZ$sp()) {
            long now = System.currentTimeMillis();
            if (now < endTime$1) {
                int sleepTime = Math.max(10 * (2 << count - 1), 1000);
                Thread.sleep(sleepTime);
                ++count;
                continue;
            }
            throw new TimeoutException();
        }
    }

    private Utils$() {
        MODULE$ = this;
    }
}

