"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateSelfSubjectAccessReview = exports.SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE = void 0;
var FetchConstants_1 = require("../../fetch/FetchConstants");
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var v1_1 = require("kubernetes-models/authorization.k8s.io/v1");
var common_1 = require("../common");
var SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE = function (args) {
    return new v1_1.SelfSubjectAccessReview({
        spec: {
            resourceAttributes: {
                resource: args.resource,
                verb: "*",
                namespace: args.namespace,
            },
        },
    }).toJSON();
};
exports.SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE = SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE;
var CreateSelfSubjectAccessReview = (function (_super) {
    __extends(CreateSelfSubjectAccessReview, _super);
    function CreateSelfSubjectAccessReview(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateSelfSubjectAccessReview.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateSelfSubjectAccessReview.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE)(__assign({}, this.args)));
    };
    CreateSelfSubjectAccessReview.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.SelfSubjectAccessReview.apiVersion, "/selfsubjectaccessreviews");
    };
    return CreateSelfSubjectAccessReview;
}(ResourceFetch_1.ResourceFetch));
exports.CreateSelfSubjectAccessReview = CreateSelfSubjectAccessReview;
//# sourceMappingURL=SelfSubjectAccessReview.js.map