"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteKafkaSource = exports.CreateKafkaSource = exports.KAFKA_SOURCE_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var common_1 = require("../common");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var api_1 = require("./api");
var KAFKA_SOURCE_TEMPLATE = function (args) { return ({
    apiVersion: api_1.KnativeApiVersions.KAFKA_SOURCE,
    kind: "KafkaSource",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        finalizers: [api_1.KAFKA_SOURCE_FINALIZER],
        labels: (0, common_1.commonLabels)(__assign({}, args)),
    },
    spec: {
        bootstrapServers: args.bootstrapServers,
        consumerGroup: args.createdBy,
        net: {
            tls: {
                enable: true,
            },
            sasl: {
                enable: true,
                type: {
                    secretKeyRef: {
                        name: args.secret.name,
                        key: args.secret.keyMechanism,
                    },
                },
                user: {
                    secretKeyRef: {
                        name: args.secret.name,
                        key: args.secret.keyId,
                    },
                },
                password: {
                    secretKeyRef: {
                        name: args.secret.name,
                        key: args.secret.keySecret,
                    },
                },
            },
        },
        sink: {
            ref: {
                apiVersion: api_1.KnativeApiVersions.SERVICE,
                kind: "Service",
                name: args.sinkService,
            },
        },
        topics: args.topics,
    },
}); };
exports.KAFKA_SOURCE_TEMPLATE = KAFKA_SOURCE_TEMPLATE;
var CreateKafkaSource = (function (_super) {
    __extends(CreateKafkaSource, _super);
    function CreateKafkaSource(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateKafkaSource.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateKafkaSource.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.KAFKA_SOURCE_TEMPLATE)(__assign({}, this.args)));
    };
    CreateKafkaSource.prototype.endpoint = function () {
        return "/apis/".concat(api_1.KnativeApiVersions.KAFKA_SOURCE, "/namespaces/").concat(this.args.namespace, "/kafkasources");
    };
    return CreateKafkaSource;
}(ResourceFetch_1.ResourceFetch));
exports.CreateKafkaSource = CreateKafkaSource;
var DeleteKafkaSource = (function (_super) {
    __extends(DeleteKafkaSource, _super);
    function DeleteKafkaSource(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteKafkaSource.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteKafkaSource.prototype.endpoint = function () {
        return "/apis/".concat(api_1.KnativeApiVersions.KAFKA_SOURCE, "/namespaces/").concat(this.args.namespace, "/kafkasources/").concat(this.args.resourceName);
    };
    return DeleteKafkaSource;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteKafkaSource = DeleteKafkaSource;
//# sourceMappingURL=KafkaSource.js.map