"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceDataSource = exports.DeploymentState = exports.runtimeLabels = exports.commonLabels = exports.ResourceLabelNames = exports.BUILD_IMAGE_TAG_VERSION = void 0;
var api_1 = require("./kubernetes/api");
var api_2 = require("./openshift/api");
exports.BUILD_IMAGE_TAG_VERSION = "1.0";
exports.ResourceLabelNames = {
    URI: "kogito.kie.org/uri",
    CREATED_BY: "kogito.kie.org/created-by",
    WORKSPACE_NAME: "kogito.kie.org/workspace-name",
};
var commonLabels = function (args) {
    var _a;
    return (_a = {},
        _a[api_1.KubernetesLabelNames.APP] = args.resourceName,
        _a[api_1.KubernetesLabelNames.COMPONENT] = args.resourceName,
        _a[api_1.KubernetesLabelNames.INSTANCE] = args.resourceName,
        _a[api_1.KubernetesLabelNames.PART_OF] = args.resourceName,
        _a[api_1.KubernetesLabelNames.NAME] = args.resourceName,
        _a[exports.ResourceLabelNames.CREATED_BY] = args.createdBy,
        _a);
};
exports.commonLabels = commonLabels;
var runtimeLabels = function () {
    var _a;
    return (_a = {},
        _a[api_2.OpenShiftLabelNames.RUNTIME] = "quarkus",
        _a[api_2.OpenShiftLabelNames.VERSION] = "openjdk-17-el7",
        _a);
};
exports.runtimeLabels = runtimeLabels;
var DeploymentState;
(function (DeploymentState) {
    DeploymentState["UP"] = "UP";
    DeploymentState["DOWN"] = "DOWN";
    DeploymentState["IN_PROGRESS"] = "IN_PROGRESS";
    DeploymentState["PREPARING"] = "PREPARING";
    DeploymentState["ERROR"] = "ERROR";
})(DeploymentState = exports.DeploymentState || (exports.DeploymentState = {}));
var ResourceDataSource;
(function (ResourceDataSource) {
    ResourceDataSource["PROVIDED"] = "PROVIDED";
    ResourceDataSource["TEMPLATE"] = "TEMPLATE";
})(ResourceDataSource = exports.ResourceDataSource || (exports.ResourceDataSource = {}));
//# sourceMappingURL=common.js.map