"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeelVariablesParser = void 0;
var antlr4_1 = require("antlr4");
var FEEL_1_1Parser_1 = require("./grammar/generated-parser/FEEL_1_1Parser");
var FEEL_1_1Lexer_1 = require("./grammar/generated-parser/FEEL_1_1Lexer");
var MapBackedType_1 = require("./grammar/MapBackedType");
var FeelSyntacticSymbolNature_1 = require("./FeelSyntacticSymbolNature");
var FeelVariablesParser = (function () {
    function FeelVariablesParser(variablesSource) {
        this.variablesRepository = variablesSource;
        this.refreshExpressions();
    }
    FeelVariablesParser.prototype.refreshExpressions = function () {
        var e_1, _a, e_2, _b, e_3, _c;
        var _d, _e;
        try {
            for (var _f = __values(this.variablesRepository.expressions.values()), _g = _f.next(); !_g.done; _g = _f.next()) {
                var expression = _g.value;
                try {
                    for (var _h = (e_2 = void 0, __values(expression.variables)), _j = _h.next(); !_j.done; _j = _h.next()) {
                        var variable = _j.value;
                        (_d = variable.source) === null || _d === void 0 ? void 0 : _d.expressions.delete(expression.uuid);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_j && !_j.done && (_b = _h.return)) _b.call(_h);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                var parsedExpression = this.parse(expression.uuid, expression.fullExpression);
                expression.variables = parsedExpression.feelVariables;
                try {
                    for (var _k = (e_3 = void 0, __values(parsedExpression.feelVariables)), _l = _k.next(); !_l.done; _l = _k.next()) {
                        var variable = _l.value;
                        (_e = variable.source) === null || _e === void 0 ? void 0 : _e.expressions.set(expression.uuid, expression);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_l && !_l.done && (_c = _k.return)) _c.call(_k);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_g && !_g.done && (_a = _f.return)) _a.call(_f);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    FeelVariablesParser.prototype.parse = function (variableContextUuid, expression) {
        var variables = new Array();
        var chars = new antlr4_1.CharStream(expression);
        var lexer = new FEEL_1_1Lexer_1.default(chars);
        var feelTokens = new antlr4_1.CommonTokenStream(lexer);
        var parser = new FEEL_1_1Parser_1.default(feelTokens);
        var variableContext = this.variablesRepository.variables.get(variableContextUuid);
        if (variableContext) {
            this.defineVariables(variableContext, parser);
        }
        parser.removeErrorListeners();
        parser.expression();
        variables.push.apply(variables, __spreadArray([], __read(parser.helper.variables), false));
        return {
            availableSymbols: parser.helper.availableSymbols,
            feelVariables: variables,
        };
    };
    FeelVariablesParser.prototype.defineVariables = function (variableContext, parser) {
        var e_4, _a;
        this.defineInputVariables(variableContext.inputVariables, parser);
        this.addToParser(parser, variableContext);
        if (variableContext.parent) {
            this.defineParentVariable(variableContext.parent, parser);
        }
        try {
            for (var _b = __values(variableContext.inputVariables), _c = _b.next(); !_c.done; _c = _b.next()) {
                var inputVariableContext = _c.value;
                var localVariable = this.variablesRepository.variables.get(inputVariableContext);
                if (localVariable) {
                    this.addToParser(parser, localVariable);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
    };
    FeelVariablesParser.prototype.defineParentVariable = function (variableNode, parser) {
        this.defineInputVariables(variableNode.inputVariables, parser);
        this.addToParser(parser, variableNode);
        if (variableNode.parent) {
            this.defineParentVariable(variableNode.parent, parser);
        }
    };
    FeelVariablesParser.prototype.createType = function (dataType) {
        var e_5, _a;
        var _b;
        if (typeof dataType !== "string") {
            var type = new MapBackedType_1.MapBackedType(dataType.name, (_b = dataType.typeRef) !== null && _b !== void 0 ? _b : dataType.name);
            try {
                for (var _c = __values(dataType.properties), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var property = _d.value;
                    var innerType = this.createType(property[1]);
                    type.properties.set(property[0], innerType);
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_5) throw e_5.error; }
            }
            return type;
        }
        else {
            return {
                name: dataType,
                typeRef: dataType,
            };
        }
    };
    FeelVariablesParser.prototype.defineInputVariables = function (inputVariables, parser) {
        var e_6, _a;
        try {
            for (var inputVariables_1 = __values(inputVariables), inputVariables_1_1 = inputVariables_1.next(); !inputVariables_1_1.done; inputVariables_1_1 = inputVariables_1.next()) {
                var inputVariableId = inputVariables_1_1.value;
                var inputVariable = this.variablesRepository.variables.get(inputVariableId);
                if (inputVariable) {
                    this.addToParser(parser, inputVariable, true);
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (inputVariables_1_1 && !inputVariables_1_1.done && (_a = inputVariables_1.return)) _a.call(inputVariables_1);
            }
            finally { if (e_6) throw e_6.error; }
        }
    };
    FeelVariablesParser.prototype.addToParser = function (parser, context, addInvisibleVariables) {
        if (context.variable.value !== "" &&
            ((!addInvisibleVariables &&
                context.variable.feelSyntacticSymbolNature != FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.InvisibleVariables) ||
                addInvisibleVariables)) {
            parser.helper.defineVariable(context.variable.value, context.variable.typeRef ? this.createType(context.variable.typeRef) : undefined, context.variable.feelSyntacticSymbolNature, context.variable, context.allowDynamicVariables);
        }
    };
    return FeelVariablesParser;
}());
exports.FeelVariablesParser = FeelVariablesParser;
//# sourceMappingURL=FeelVariablesParser.js.map