import React from "react";
import { PlayIcon } from "@patternfly/react-icons/dist/js/icons/play-icon";
import { SitemapIcon } from "@patternfly/react-icons/dist/js/icons/sitemap-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
export const getColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => React.createElement("span", null, value),
    };
};
export const getActionColumn = (startWorkflow, triggerCloudEvent) => {
    return {
        label: "Actions",
        path: "actions",
        bodyCellTransformer: (value, rowData) => (React.createElement(React.Fragment, null,
            React.createElement(Tooltip, { content: `Start new workflow` },
                React.createElement(Button, { onClick: () => startWorkflow(rowData), variant: "link" },
                    React.createElement(PlayIcon, null))),
            React.createElement(Tooltip, { content: `Trigger cloud event` },
                React.createElement(Button, { onClick: () => triggerCloudEvent(rowData), variant: "link" },
                    React.createElement(SitemapIcon, null))))),
    };
};
//# sourceMappingURL=WorkflowDefinitionListUtils.js.map