import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { Resizable } from "react-resizable";
import { useResizingWidthsDispatch } from "../../resizing/ResizingWidthsContext";
import { DEFAULT_MIN_WIDTH } from "../WidthConstants";
import "./Resizer.css";
export const Resizer = ({ minWidth, width, setWidth, resizingWidth, setResizingWidth, setResizing, getWidthToFitData, }) => {
    const { getResizerRefs, setResizing: _setResizing } = useResizingWidthsDispatch();
    const [resizingStop__data, setResizingStop__data] = useState({ width: 0 });
    const [startResizingWidth, setStartResizingWidth] = useState({ width: 0 });
    const onResizeStop = useCallback((e, data) => {
        if (e.detail === 2) {
            console.debug("Skipping resizeStop onMouseUp because onDoubleClick will handle it.");
            return;
        }
        setResizingStop__data({ width: data.size.width });
    }, []);
    useEffect(() => {
        var _a, _b;
        const resizingStopWidth = Math.floor(resizingStop__data.width);
        if (!resizingStopWidth) {
            return;
        }
        if (resizingStopWidth === startResizingWidth.width) {
            console.debug(`Stop resizing (equal): ${resizingStopWidth}`);
        }
        else {
            console.debug(`Stop resizing (different): ${resizingStopWidth}`);
            for (const resizerRef of getResizerRefs()) {
                if (((_a = resizerRef.resizingWidth) === null || _a === void 0 ? void 0 : _a.value) !== resizerRef.width) {
                    (_b = resizerRef.setWidth) === null || _b === void 0 ? void 0 : _b.call(resizerRef, (prev) => { var _a, _b, _c; return (_c = (_b = (_a = resizerRef.resizingWidth) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : prev) !== null && _c !== void 0 ? _c : 0; });
                }
                else {
                }
            }
            if (resizingStopWidth !== width) {
                setWidth === null || setWidth === void 0 ? void 0 : setWidth(resizingStopWidth);
            }
        }
        setResizing === null || setResizing === void 0 ? void 0 : setResizing(false);
        _setResizing(false);
        setResizingWidth === null || setResizingWidth === void 0 ? void 0 : setResizingWidth({ value: resizingStopWidth, isPivoting: false });
        setResizingStop__data({ width: 0 });
    }, [
        _setResizing,
        getResizerRefs,
        setResizing,
        setResizingWidth,
        setWidth,
        resizingStop__data.width,
        startResizingWidth.width,
        width,
    ]);
    const minConstraints = useMemo(() => {
        return [minWidth !== null && minWidth !== void 0 ? minWidth : DEFAULT_MIN_WIDTH, 0];
    }, [minWidth]);
    const onResize = useCallback((_, data) => {
        setResizingWidth === null || setResizingWidth === void 0 ? void 0 : setResizingWidth({ value: Math.floor(data.size.width), isPivoting: true });
    }, [setResizingWidth]);
    const onResizeStart = useCallback((_, data) => {
        const startResizingWidth = Math.floor(data.size.width);
        console.debug(`Start resizing: ${startResizingWidth}`);
        setStartResizingWidth({ width: startResizingWidth });
        setResizingWidth === null || setResizingWidth === void 0 ? void 0 : setResizingWidth({ value: startResizingWidth, isPivoting: true });
        setResizing === null || setResizing === void 0 ? void 0 : setResizing(true);
        _setResizing(true);
    }, [_setResizing, setResizing, setResizingWidth]);
    const onDoubleClick = useCallback((e) => {
        var _a;
        e.stopPropagation();
        let widthToFitData;
        try {
            widthToFitData = getWidthToFitData === null || getWidthToFitData === void 0 ? void 0 : getWidthToFitData();
        }
        catch (e) {
        }
        const newWidth = Math.max((_a = widthToFitData !== null && widthToFitData !== void 0 ? widthToFitData : minWidth) !== null && _a !== void 0 ? _a : DEFAULT_MIN_WIDTH, minWidth !== null && minWidth !== void 0 ? minWidth : DEFAULT_MIN_WIDTH);
        onResizeStart(undefined, { size: { width: newWidth } });
        setTimeout(() => {
            setStartResizingWidth({ width: 0 });
            setResizingStop__data({ width: newWidth });
        }, 0);
    }, [getWidthToFitData, minWidth, onResizeStart]);
    const style = useMemo(() => {
        return { width: resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value, minWidth };
    }, [minWidth, resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value]);
    const debuggingHandleClassNames = "";
    return (_jsx(_Fragment, { children: width && resizingWidth && (_jsx(Resizable, Object.assign({ width: resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value, height: 0, onResize: onResize, onResizeStop: onResizeStop, onResizeStart: onResizeStart, minConstraints: minConstraints, className: "resizable-div", axis: "x", handle: _jsx("div", Object.assign({ className: "pf-c-drawer", onDoubleClick: onDoubleClick, "data-testid": "resizer-handle" }, { children: _jsx("div", Object.assign({ className: `pf-c-drawer__splitter pf-m-vertical ${debuggingHandleClassNames}` }, { children: _jsx("div", { className: `pf-c-drawer__splitter-handle` }) })) })) }, { children: _jsx("div", { style: style }) }))) }));
};
//# sourceMappingURL=Resizer.js.map