import { jsx as _jsx } from "react/jsx-runtime";
import "@patternfly/react-styles/css/utilities/Text/text.css";
import { useCallback, useMemo, useRef } from "react";
import { BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, generateUuid, getNextAvailablePrefixedName, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { usePublishedBeeTableResizableColumns } from "../../resizing/BeeTableResizableColumnsContext";
import { useApportionedColumnWidthsIfNestedTable, useNestedTableLastColumnMinWidth } from "../../resizing/Hooks";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH, RELATION_EXPRESSION_COLUMN_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { BeeTable } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import "./RelationExpression.css";
export const RELATION_EXPRESSION_DEFAULT_VALUE = "";
export function RelationExpression({ isNested, parentElementId, expression: relationExpression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { widthsById, expressionHolderId } = useBoxedExpressionEditor();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const id = relationExpression["@_id"];
    const beeTableOperationConfig = useMemo(() => [
        {
            group: i18n.columns,
            items: [
                { name: i18n.columnOperations.insertLeft, type: BeeTableOperation.ColumnInsertLeft },
                { name: i18n.columnOperations.insertRight, type: BeeTableOperation.ColumnInsertRight },
                { name: i18n.insert, type: BeeTableOperation.ColumnInsertN },
                { name: i18n.columnOperations.delete, type: BeeTableOperation.ColumnDelete },
            ],
        },
        {
            group: i18n.rows,
            items: [
                { name: i18n.rowOperations.insertAbove, type: BeeTableOperation.RowInsertAbove },
                { name: i18n.rowOperations.insertBelow, type: BeeTableOperation.RowInsertBelow },
                { name: i18n.insert, type: BeeTableOperation.RowInsertN },
                { name: i18n.rowOperations.delete, type: BeeTableOperation.RowDelete },
                { name: i18n.rowOperations.duplicate, type: BeeTableOperation.RowDuplicate },
            ],
        },
        {
            group: i18n.terms.selection.toUpperCase(),
            items: [
                { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                { name: i18n.terms.cut, type: BeeTableOperation.SelectionCut },
                { name: i18n.terms.paste, type: BeeTableOperation.SelectionPaste },
                { name: i18n.terms.reset, type: BeeTableOperation.SelectionReset },
            ],
        },
    ], [i18n]);
    const widths = useMemo(() => { var _a; return (_a = widthsById.get(id)) !== null && _a !== void 0 ? _a : []; }, [id, widthsById]);
    const getColumnWidth = useCallback((columnIndex, widths) => {
        var _a;
        return (_a = widths[columnIndex]) !== null && _a !== void 0 ? _a : RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH;
    }, []);
    const columns = useMemo(() => {
        var _a;
        return ((_a = relationExpression.column) !== null && _a !== void 0 ? _a : []).map((c, index) => (Object.assign(Object.assign({}, c), { minWidth: RELATION_EXPRESSION_COLUMN_MIN_WIDTH, width: getColumnWidth(index + 1, widths) })));
    }, [getColumnWidth, relationExpression.column, widths]);
    const rows = useMemo(() => {
        var _a;
        return (_a = relationExpression.row) !== null && _a !== void 0 ? _a : [];
    }, [relationExpression]);
    const setColumnWidth = useCallback((columnIndex) => (newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const prevColumnWidth = getColumnWidth(columnIndex, prev);
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(prevColumnWidth) : newWidthAction;
            if (newWidth && prevColumnWidth) {
                const minSize = columnIndex + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)));
                newValues.splice(columnIndex, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [getColumnWidth, setWidthsById, id]);
    const beeTableRef = useRef(null);
    const { onColumnResizingWidthChange, columnResizingWidths, isPivoting } = usePublishedBeeTableResizableColumns(relationExpression["@_id"], columns.length, true);
    useNestedTableLastColumnMinWidth(columnResizingWidths);
    useApportionedColumnWidthsIfNestedTable(beeTableRef, isPivoting, isNested, BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, columns, columnResizingWidths, rows);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = relationExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = relationExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                width: undefined,
                columns: columns.map((column, columnIndex) => {
                    var _a;
                    return ({
                        accessor: column["@_id"],
                        label: column["@_name"],
                        dataType: (_a = column["@_typeRef"]) !== null && _a !== void 0 ? _a : DmnBuiltInDataType.Undefined,
                        isRowIndexColumn: false,
                        minWidth: RELATION_EXPRESSION_COLUMN_MIN_WIDTH,
                        setWidth: setColumnWidth(columnIndex + 1),
                        width: getColumnWidth(columnIndex + 1, widths),
                    });
                }),
            },
        ];
    }, [columns, expressionHolderId, getColumnWidth, relationExpression, setColumnWidth, widths]);
    const beeTableRows = useMemo(() => rows.map((row) => {
        return columns.reduce((tableRow, column, columnIndex) => {
            var _a, _b, _c, _d;
            const cellExpression = (_a = row.expression) === null || _a === void 0 ? void 0 : _a[columnIndex];
            if ((cellExpression === null || cellExpression === void 0 ? void 0 : cellExpression.__$$element) === "literalExpression") {
                tableRow[column["@_id"]] = {
                    id: (_b = cellExpression["@_id"]) !== null && _b !== void 0 ? _b : generateUuid(),
                    content: (_d = (_c = cellExpression.text) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "",
                };
            }
            return tableRow;
        }, { id: row["@_id"] });
    }), [rows, columns]);
    const onCellUpdates = useCallback((cellUpdates) => {
        setExpression((prev) => {
            let previousExpression = Object.assign({}, prev);
            cellUpdates.forEach((cellUpdate) => {
                var _a, _b;
                const newRows = [...((_a = previousExpression.row) !== null && _a !== void 0 ? _a : [])];
                const newExpressions = [...((_b = newRows[cellUpdate.rowIndex].expression) !== null && _b !== void 0 ? _b : [])];
                newExpressions[cellUpdate.columnIndex] = Object.assign(Object.assign({}, newExpressions[cellUpdate.columnIndex]), { __$$element: "literalExpression", text: {
                        __$$text: cellUpdate.value,
                    } });
                newRows[cellUpdate.rowIndex] = Object.assign(Object.assign({}, newRows[cellUpdate.rowIndex]), { expression: newExpressions });
                previousExpression = Object.assign(Object.assign({}, previousExpression), { row: newRows });
            });
            return previousExpression;
        });
    }, [setExpression]);
    const onColumnUpdates = useCallback((columnUpdates) => {
        setExpression((prev) => {
            var _a;
            const n = Object.assign({}, prev);
            const newColumns = [...((_a = prev.column) !== null && _a !== void 0 ? _a : [])];
            for (const u of columnUpdates) {
                if (u.column.depth === 0) {
                    n["@_typeRef"] = u.typeRef;
                    n["@_label"] = u.name;
                }
                else {
                    newColumns[u.columnIndex] = Object.assign(Object.assign({}, newColumns[u.columnIndex]), { "@_name": u.name, "@_typeRef": u.typeRef });
                }
            }
            const ret = Object.assign(Object.assign({}, n), { column: newColumns });
            return ret;
        });
    }, [setExpression]);
    const createCell = useCallback(() => {
        const cell = {
            __$$element: "literalExpression",
            "@_id": generateUuid(),
            text: {
                __$$text: RELATION_EXPRESSION_DEFAULT_VALUE,
            },
        };
        return cell;
    }, []);
    const onRowAdded = useCallback((args) => {
        setExpression((prev) => {
            var _a, _b, _c;
            const newRows = [...((_a = prev.row) !== null && _a !== void 0 ? _a : [])];
            const newItems = [];
            for (let i = 0; i < args.rowsCount; i++) {
                newItems.push({
                    "@_id": generateUuid(),
                    expression: Array.from(new Array((_c = (_b = prev.column) === null || _b === void 0 ? void 0 : _b.length) !== null && _c !== void 0 ? _c : 0)).map(() => {
                        return createCell();
                    }),
                });
            }
            for (const newEntry of newItems) {
                newRows.splice(args.beforeIndex, 0, newEntry);
            }
            const ret = Object.assign(Object.assign({}, prev), { row: newRows });
            return ret;
        });
    }, [createCell, setExpression]);
    const onColumnAdded = useCallback((args) => {
        setExpression((prev) => {
            var _a, _b, _c, _d;
            const newColumns = [...((_a = prev.column) !== null && _a !== void 0 ? _a : [])];
            const newItems = [];
            const availableNames = (_c = (_b = prev.column) === null || _b === void 0 ? void 0 : _b.map((c) => c["@_name"])) !== null && _c !== void 0 ? _c : [];
            for (let i = 0; i < args.columnsCount; i++) {
                const name = getNextAvailablePrefixedName(availableNames, "column");
                availableNames.push(name);
                newItems.push({
                    "@_id": generateUuid(),
                    "@_name": name,
                    "@_typeRef": undefined,
                });
            }
            for (const newEntry of newItems) {
                newColumns.splice(args.beforeIndex, 0, newEntry);
            }
            const newRows = [...((_d = prev.row) !== null && _d !== void 0 ? _d : [])].map((row) => {
                var _a;
                const newCells = [...((_a = row.expression) !== null && _a !== void 0 ? _a : [])];
                newCells.splice(args.beforeIndex, 0, createCell());
                return Object.assign(Object.assign({}, row), { expression: newCells });
            });
            const ret = Object.assign(Object.assign({}, prev), { column: newColumns, row: newRows });
            return ret;
        });
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const defaultWidth = RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH;
            const newValues = [...prev];
            for (let i = 0; i < args.columnsCount; i++) {
                newValues.splice(args.beforeIndex + 1, 0, defaultWidth);
            }
            newMap.set(id, newValues);
        });
    }, [createCell, id, setExpression, setWidthsById]);
    const onColumnDeleted = useCallback((args) => {
        setExpression((prev) => {
            var _a, _b;
            const newColumns = [...((_a = prev.column) !== null && _a !== void 0 ? _a : [])];
            newColumns.splice(args.columnIndex, 1);
            const newRows = [...((_b = prev.row) !== null && _b !== void 0 ? _b : [])].map((row) => {
                var _a;
                const newCells = [...((_a = row.expression) !== null && _a !== void 0 ? _a : [])];
                newCells.splice(args.columnIndex, 1);
                return Object.assign(Object.assign({}, row), { expression: newCells });
            });
            const ret = Object.assign(Object.assign({}, prev), { column: newColumns, row: newRows });
            return ret;
        });
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const newValues = [...prev];
            newValues.splice(args.columnIndex + 1, 1);
            newMap.set(id, newValues);
        });
    }, [id, setExpression, setWidthsById]);
    const onRowDeleted = useCallback((args) => {
        setExpression((prev) => {
            var _a;
            const newRows = [...((_a = prev.row) !== null && _a !== void 0 ? _a : [])];
            newRows.splice(args.rowIndex, 1);
            const ret = Object.assign(Object.assign({}, prev), { row: newRows });
            return ret;
        });
    }, [setExpression]);
    const onRowDuplicated = useCallback((args) => {
        setExpression((prev) => {
            var _a, _b;
            const duplicatedRow = {
                "@_id": generateUuid(),
                expression: (_a = prev.row[args.rowIndex].expression) === null || _a === void 0 ? void 0 : _a.map((cell) => (Object.assign(Object.assign({}, cell), { "@_id": generateUuid() }))),
            };
            const newRows = [...((_b = prev.row) !== null && _b !== void 0 ? _b : [])];
            newRows.splice(args.rowIndex, 0, duplicatedRow);
            const ret = Object.assign(Object.assign({}, prev), { row: newRows });
            return ret;
        });
    }, [setExpression]);
    const beeTableHeaderVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.LastLevel : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const allowedOperations = useCallback((conditions) => {
        var _a, _b;
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        const columnIndex = conditions.selection.selectionStart.columnIndex;
        const columnCanBeDeleted = ((_b = (_a = conditions.columns) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) > 2;
        const columnOperations = columnIndex === 0
            ? []
            : [
                BeeTableOperation.ColumnInsertLeft,
                BeeTableOperation.ColumnInsertRight,
                BeeTableOperation.ColumnInsertN,
                ...(columnCanBeDeleted ? [BeeTableOperation.ColumnDelete] : []),
            ];
        return [
            ...columnOperations,
            BeeTableOperation.SelectionCopy,
            ...(columnIndex > 0 && conditions.selection.selectionStart.rowIndex >= 0
                ? [BeeTableOperation.SelectionCut, BeeTableOperation.SelectionPaste, BeeTableOperation.SelectionReset]
                : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0
                ? [
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowInsertN,
                    ...(beeTableRows.length > 1 ? [BeeTableOperation.RowDelete] : []),
                    BeeTableOperation.RowReset,
                    BeeTableOperation.RowDuplicate,
                ]
                : []),
        ];
    }, [beeTableRows.length]);
    return (_jsx("div", Object.assign({ className: `relation-expression` }, { children: _jsx(BeeTable, { resizerStopBehavior: isPivoting ? ResizerStopBehavior.SET_WIDTH_ALWAYS : ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, forwardRef: beeTableRef, headerLevelCountForAppendingRowIndexColumn: 1, editColumnLabel: i18n.editRelation, columns: beeTableColumns, headerVisibility: beeTableHeaderVisibility, rows: beeTableRows, onCellUpdates: onCellUpdates, onColumnUpdates: onColumnUpdates, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onRowAdded: onRowAdded, onRowDuplicated: onRowDuplicated, onRowDeleted: onRowDeleted, onColumnAdded: onColumnAdded, onColumnDeleted: onColumnDeleted, onColumnResizingWidthChange: onColumnResizingWidthChange, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: true, shouldShowColumnsInlineControls: true }) })));
}
//# sourceMappingURL=RelationExpression.js.map