import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditor, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { useCallback, useEffect, useMemo } from "react";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import "./FilterExpression.css";
import { NestedExpressionContainerContext, useNestedExpressionContainer, } from "../../resizing/NestedExpressionContainerContext";
import { FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH } from "../../resizing/WidthConstants";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export function FilterExpressionMatchCell({ rowIndex, data: items, columnIndex, parentElementId, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { expression } = items[0];
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(expression === null || expression === void 0 ? void 0 : expression["@_id"]);
        }
    }, [beeGwtService, expression, isActive]);
    const onSetExpression = useCallback(({ getNewExpression }) => {
        setExpression((prev) => {
            const newExpression = getNewExpression(prev.match.expression);
            const ret = Object.assign(Object.assign({}, prev), { match: Object.assign(Object.assign({}, prev.match), { expression: newExpression }) });
            return ret;
        });
    }, [setExpression]);
    const nestedExpressionContainer = useNestedExpressionContainer();
    const nestedExpressionContainerValue = useMemo(() => {
        return {
            minWidth: nestedExpressionContainer.minWidth - FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH,
            actualWidth: nestedExpressionContainer.actualWidth - FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH,
            resizingWidth: {
                value: nestedExpressionContainer.resizingWidth.value - FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH,
                isPivoting: nestedExpressionContainer.resizingWidth.isPivoting,
            },
        };
    }, [
        nestedExpressionContainer.actualWidth,
        nestedExpressionContainer.minWidth,
        nestedExpressionContainer.resizingWidth.isPivoting,
        nestedExpressionContainer.resizingWidth.value,
    ]);
    return (_jsxs("div", Object.assign({ className: "filter-expression-cell" }, { children: [_jsx("div", Object.assign({ className: "bracket-sign-container", style: { borderRight: "1px solid var(--pf-global--palette--black-300)" } }, { children: _jsx("div", Object.assign({ className: "bracket-sign" }, { children: "[" })) })), _jsx("div", Object.assign({ "data-testid": "kie-tools--boxed-expression-component--filter-collection-match" }, { children: _jsx(NestedExpressionContainerContext.Provider, Object.assign({ value: nestedExpressionContainerValue }, { children: _jsx(NestedExpressionDispatchContextProvider, Object.assign({ onSetExpression: onSetExpression }, { children: _jsx(ExpressionContainer, { expression: items[0].expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: undefined, parentElementName: undefined }) })) })) })), _jsx("div", Object.assign({ className: "bracket-sign-container", style: { borderLeft: "1px solid var(--pf-global--palette--black-300)" } }, { children: _jsx("div", Object.assign({ className: "bracket-sign" }, { children: "]" })) }))] })));
}
//# sourceMappingURL=FilterExpressionMatchCell.js.map