import { findAllIdsDeep } from "../ids/ids";
export const DMN_BOXED_EXPRESSION_CLIPBOARD_MIME_TYPE = "application/json+kie-dmn-boxed-expression-editor--expression";
export function buildClipboardFromExpression(expression, widthsById) {
    const originalIds = findAllIdsDeep(expression);
    const widthsByIdObj = [...widthsById.entries()].reduce((acc, [k, v]) => {
        if (originalIds.has(k)) {
            acc[k] = v;
        }
        return acc;
    }, {});
    return {
        mimeType: DMN_BOXED_EXPRESSION_CLIPBOARD_MIME_TYPE,
        expression,
        widthsById: widthsByIdObj,
    };
}
//# sourceMappingURL=clipboard.js.map