"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.XmlParserTsIdRandomizer = void 0;
var qNames_1 = require("./qNames");
var XmlParserTsIdRandomizer = (function () {
    function XmlParserTsIdRandomizer(args) {
        this.args = args;
        this.updaters = new Map();
        this.toAttribute = new Map();
        this.attributed = new Map();
        this.randomized = new Map();
    }
    XmlParserTsIdRandomizer.prototype.getOriginalIds = function () {
        return new Set(__spreadArray([], __read(this.updaters.keys()), false));
    };
    XmlParserTsIdRandomizer.prototype.ack = function (_a) {
        var e_1, _b;
        var _c, _d, _e, _f, _g;
        var json = _a.json, parentJson = _a.parentJson, type = _a.type, attr = _a.attr, __$$element = _a.__$$element, arrayIndex = _a.arrayIndex, path = _a.path;
        var rootMetaProp = this.args.meta[type][attr];
        if (json === undefined && !(rootMetaProp.xsdType === "xsd:ID")) {
            console.debug("ID RANDOMIZER: ack: ".concat(String(type), ".").concat(String(attr), ": ").concat(json, ". skip."));
            return this;
        }
        var resolvedRootMetaPropTypeName = (_c = this.args.elements[__$$element !== null && __$$element !== void 0 ? __$$element : json === null || json === void 0 ? void 0 : json.__$$element]) !== null && _c !== void 0 ? _c : rootMetaProp.type;
        if (rootMetaProp.isArray && arrayIndex === undefined) {
            for (var index = 0; index < json.length; index++) {
                this.ack({
                    json: json[index],
                    parentJson: json,
                    attr: attr,
                    type: type,
                    arrayIndex: index,
                    path: path === undefined ? "".concat(String(attr), ".").concat(index) : "".concat(path, ".").concat(index),
                });
            }
        }
        else if (this.args.meta[resolvedRootMetaPropTypeName]) {
            var resolvedMetaType = this.args.meta[resolvedRootMetaPropTypeName];
            for (var metaPropName in resolvedMetaType) {
                this.ack({
                    json: json[metaPropName],
                    parentJson: json,
                    attr: metaPropName,
                    type: resolvedRootMetaPropTypeName,
                    path: path === undefined ? "".concat(String(attr), ".").concat(metaPropName) : "".concat(path, ".").concat(metaPropName),
                });
            }
        }
        else {
            console.debug("ID RANDOMIZER: ack: ".concat(String(type), ".").concat(String(attr), ": ").concat(json, " --> ").concat(rootMetaProp.xsdType));
            var accessor_1 = arrayIndex !== null && arrayIndex !== void 0 ? arrayIndex : attr;
            if (rootMetaProp.xsdType === "xsd:ID" || rootMetaProp.xsdType === "xsd:IDREF") {
                var u = function (_a) {
                    var newId = _a.newId;
                    console.debug("ID RANDOMIZER: [ID,IDREF] Updating id from ".concat(parentJson[accessor_1], " to ").concat(newId, " @ (").concat(String(type), ".").concat(String(attr), ": ").concat(json, ")"));
                    return (parentJson[accessor_1] = newId);
                };
                if (json === undefined) {
                    this.toAttribute.set(path === undefined ? String(attr) : path, u);
                }
                else {
                    this.updaters.set(json, __spreadArray(__spreadArray([], __read(((_d = this.updaters.get(json)) !== null && _d !== void 0 ? _d : [])), false), [u], false));
                }
            }
            else if (rootMetaProp.xsdType === "xsd:QName") {
                var qname_1 = (0, qNames_1.parseXmlQName)(json !== null && json !== void 0 ? json : "");
                var u = function (_a) {
                    var newId = _a.newId;
                    console.debug("ID RANDOMIZER: [QName] Updating id from ".concat(qname_1.localPart, " to ").concat(newId, " @ (").concat(String(type), ".").concat(String(attr), ": ").concat(json, ")"));
                    return (parentJson[accessor_1] = (0, qNames_1.buildXmlQName)(__assign(__assign({}, qname_1), { localPart: newId })));
                };
                this.updaters.set(qname_1.localPart, __spreadArray(__spreadArray([], __read(((_e = this.updaters.get(qname_1.localPart)) !== null && _e !== void 0 ? _e : [])), false), [u], false));
            }
            else {
                try {
                    for (var _h = __values((_f = this.args.matchers) !== null && _f !== void 0 ? _f : []), _j = _h.next(); !_j.done; _j = _h.next()) {
                        var c = _j.value;
                        var matcherResult = c({
                            metaTypeName: type,
                            metaType: this.args.meta[type],
                            attr: String(attr),
                            parentJson: parentJson,
                        });
                        if (matcherResult) {
                            var _k = __read(matcherResult, 2), id = _k[0], u = _k[1];
                            this.updaters.set(id, __spreadArray(__spreadArray([], __read(((_g = this.updaters.get(id)) !== null && _g !== void 0 ? _g : [])), false), [u], false));
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_j && !_j.done && (_b = _h.return)) _b.call(_h);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
        }
        return this;
    };
    XmlParserTsIdRandomizer.prototype.randomize = function (args) {
        var e_2, _a, e_3, _b, e_4, _c, e_5, _d;
        try {
            for (var _e = __values(this.toAttribute), _f = _e.next(); !_f.done; _f = _e.next()) {
                var _g = __read(_f.value, 2), path = _g[0], u = _g[1];
                var newId = this.args.newIdGenerator();
                this.attributed.set(path, newId);
                u({ newId: newId });
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
            }
            finally { if (e_2) throw e_2.error; }
        }
        try {
            for (var _h = __values(this.updaters), _j = _h.next(); !_j.done; _j = _h.next()) {
                var _k = __read(_j.value, 2), id = _k[0], us = _k[1];
                if (id === undefined) {
                    var newId = this.args.newIdGenerator();
                    this.randomized.set(id, newId);
                    try {
                        for (var us_1 = (e_4 = void 0, __values(us)), us_1_1 = us_1.next(); !us_1_1.done; us_1_1 = us_1.next()) {
                            var u = us_1_1.value;
                            u({ newId: newId });
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (us_1_1 && !us_1_1.done && (_c = us_1.return)) _c.call(us_1);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                }
                else if ((args === null || args === void 0 ? void 0 : args.skipAlreadyAttributedIds) === false) {
                    var newId = this.args.newIdGenerator();
                    this.randomized.set(id, newId);
                    try {
                        for (var us_2 = (e_5 = void 0, __values(us)), us_2_1 = us_2.next(); !us_2_1.done; us_2_1 = us_2.next()) {
                            var u = us_2_1.value;
                            u({ newId: newId });
                        }
                    }
                    catch (e_5_1) { e_5 = { error: e_5_1 }; }
                    finally {
                        try {
                            if (us_2_1 && !us_2_1.done && (_d = us_2.return)) _d.call(us_2);
                        }
                        finally { if (e_5) throw e_5.error; }
                    }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_j && !_j.done && (_b = _h.return)) _b.call(_h);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return this;
    };
    XmlParserTsIdRandomizer.prototype.getAttributed = function () {
        return this.attributed;
    };
    XmlParserTsIdRandomizer.prototype.getRandomized = function () {
        return this.randomized;
    };
    return XmlParserTsIdRandomizer;
}());
exports.XmlParserTsIdRandomizer = XmlParserTsIdRandomizer;
//# sourceMappingURL=idRandomizer.js.map