"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScorecardReducer = void 0;
var Actions_1 = require("./Actions");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var immer_1 = require("immer");
var Outputs_1 = require("../validation/Outputs");
var paths_1 = require("../paths");
var Characteristics_1 = require("../validation/Characteristics");
var ModelCoreProperties_1 = require("../validation/ModelCoreProperties");
var PMMLModelHelper_1 = require("../PMMLModelHelper");
pmml_editor_marshaller_1.Scorecard[immer_1.immerable] = true;
var ScorecardReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        var _a, _b;
        switch (action.type) {
            case Actions_1.Actions.Scorecard_SetModelName:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function (draft) {
                    draft.modelName = action.payload.modelName;
                });
                break;
            case Actions_1.Actions.Scorecard_SetCoreProperties:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function (draft) {
                    draft.isScorable = action.payload.isScorable;
                    draft.functionName = action.payload.functionName;
                    draft.algorithmName = action.payload.algorithmName;
                    draft.baselineScore = action.payload.baselineScore;
                    draft.baselineMethod = action.payload.baselineMethod;
                    draft.initialScore = action.payload.initialScore;
                    draft.useReasonCodes = action.payload.useReasonCodes;
                    draft.reasonCodeAlgorithm = action.payload.reasonCodeAlgorithm;
                    if (!(action.payload.useReasonCodes === undefined || action.payload.useReasonCodes)) {
                        draft.Characteristics.Characteristic.forEach(function (characteristic) {
                            characteristic.reasonCode = undefined;
                            characteristic.Attribute.forEach(function (attribute) { return (attribute.reasonCode = undefined); });
                        });
                    }
                    if (action.payload.baselineScore !== undefined) {
                        draft.Characteristics.Characteristic.forEach(function (characteristic) {
                            characteristic.baselineScore = undefined;
                        });
                    }
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex);
                    var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex);
                    var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forBaselineScore().build());
                        (0, ModelCoreProperties_1.validateBaselineScore)(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().build());
                        (0, Characteristics_1.validateCharacteristics)(modelIndex, {
                            baselineScore: baselineScore,
                            useReasonCodes: useReasonCodes,
                        }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.Scorecard_AddCharacteristic:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function () {
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex);
                    var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex);
                    var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(action.payload.modelIndex).forBaselineScore().build());
                        (0, ModelCoreProperties_1.validateBaselineScore)(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().build());
                        (0, Characteristics_1.validateCharacteristics)(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.Scorecard_DeleteCharacteristic:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function () {
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex);
                    var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex);
                    var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex);
                    if (characteristics !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forBaselineScore().build());
                        (0, ModelCoreProperties_1.validateBaselineScore)(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.Scorecard_UpdateCharacteristic:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function () {
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex);
                    var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex);
                    var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forBaselineScore().build());
                        (0, ModelCoreProperties_1.validateBaselineScore)(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().build());
                        (0, Characteristics_1.validateCharacteristics)(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.Scorecard_AddAttribute:
            case Actions_1.Actions.Scorecard_DeleteAttribute:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function () {
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var characteristicIndex = action.payload.characteristicIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex);
                    var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex);
                    var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().forCharacteristic(characteristicIndex).build());
                        (0, Characteristics_1.validateCharacteristic)(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristicIndex, characteristics.Characteristic[characteristicIndex], miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.UpdateDataDictionaryField:
                if (action.payload.modelIndex !== undefined) {
                    var modelIndex_1 = action.payload.modelIndex;
                    var dataFieldName_1 = action.payload.dataField.name;
                    var originalDataFieldName_1 = action.payload.originalName;
                    state.Characteristics.Characteristic.forEach(function (characteristic, characteristicIndex) {
                        characteristic.Attribute.forEach(function (attribute, attributeIndex) {
                            updatePredicateFieldName((0, paths_1.Builder)()
                                .forModel(modelIndex_1)
                                .forCharacteristics()
                                .forCharacteristic(characteristicIndex)
                                .forAttribute(attributeIndex)
                                .forPredicate(), attribute.predicate, dataFieldName_1, originalDataFieldName_1, historyService);
                        });
                    });
                }
                break;
            case Actions_1.Actions.AddMiningSchemaFields:
            case Actions_1.Actions.Scorecard_UpdateAttribute:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).build(), function () {
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex);
                    var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex);
                    var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().build());
                        (0, Characteristics_1.validateCharacteristics)(action.payload.modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.DeleteMiningSchemaField:
                if (state.MiningSchema.MiningField.length > 0) {
                    var modelIndex_2 = action.payload.modelIndex;
                    historyService.batch(state, (0, paths_1.Builder)().forModel(modelIndex_2).build(), function (draft) {
                    }, function (pmml) {
                        var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex_2);
                        var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex_2);
                        var baselineScore = (0, PMMLModelHelper_1.getBaselineScore)(pmml, modelIndex_2);
                        var useReasonCodes = (0, PMMLModelHelper_1.getUseReasonCodes)(pmml, modelIndex_2);
                        if (miningSchema !== undefined && characteristics !== undefined) {
                            validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex_2).forCharacteristics().build());
                            (0, Characteristics_1.validateCharacteristics)(modelIndex_2, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                        }
                    });
                }
                break;
            case Actions_1.Actions.Validate:
                if (action.payload.modelIndex !== undefined) {
                    var modelIndex = action.payload.modelIndex;
                    validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forOutput().build());
                    (0, Outputs_1.validateOutputs)(modelIndex, (_b = (_a = state.Output) === null || _a === void 0 ? void 0 : _a.OutputField) !== null && _b !== void 0 ? _b : [], state.MiningSchema.MiningField, validationRegistry);
                    validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forBaselineScore().build());
                    (0, ModelCoreProperties_1.validateBaselineScore)(modelIndex, state.useReasonCodes, state.baselineScore, state.Characteristics.Characteristic, validationRegistry);
                    validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().build());
                    (0, Characteristics_1.validateCharacteristics)(modelIndex, { baselineScore: state.baselineScore, useReasonCodes: state.useReasonCodes }, state.Characteristics.Characteristic, state.MiningSchema.MiningField, validationRegistry);
                }
        }
        return state;
    };
};
exports.ScorecardReducer = ScorecardReducer;
var updatePredicateFieldName = function (pathBuilder, predicate, name, originalName, service) {
    var _a;
    if (predicate === undefined) {
        return;
    }
    else if (predicate instanceof pmml_editor_marshaller_1.True) {
        return;
    }
    else if (predicate instanceof pmml_editor_marshaller_1.False) {
        return;
    }
    if (predicate instanceof pmml_editor_marshaller_1.SimpleSetPredicate) {
        if (originalName === predicate.field) {
            service.batch(predicate, pathBuilder.build(), function (draft) {
                draft.field = name;
            });
        }
    }
    else if (predicate instanceof pmml_editor_marshaller_1.SimplePredicate) {
        if (originalName === predicate.field) {
            service.batch(predicate, pathBuilder.build(), function (draft) {
                draft.field = name;
            });
        }
    }
    else if (predicate instanceof pmml_editor_marshaller_1.CompoundPredicate) {
        var cp = predicate;
        (_a = cp.predicates) === null || _a === void 0 ? void 0 : _a.forEach(function (p, i) {
            return updatePredicateFieldName(pathBuilder.forPredicate(i), p, name, originalName, service);
        });
    }
};
//# sourceMappingURL=ScorecardReducer.js.map