"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiningSchemaReducer = void 0;
var Actions_1 = require("./Actions");
var paths_1 = require("../paths");
var MiningSchema_1 = require("../validation/MiningSchema");
var PMMLModelHelper_1 = require("../PMMLModelHelper");
var MiningSchemaReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.AddMiningSchemaFields:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forMiningSchema().build(), function (draft) {
                    action.payload.names.forEach(function (name) {
                        draft.MiningField.push({
                            name: name,
                        });
                    });
                });
                break;
            case Actions_1.Actions.DeleteMiningSchemaField:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forMiningSchema().build(), function (draft) {
                    var miningSchemaIndex = action.payload.miningSchemaIndex;
                    if (miningSchemaIndex >= 0 && miningSchemaIndex < draft.MiningField.length) {
                        draft.MiningField.splice(miningSchemaIndex, 1);
                    }
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    if (miningSchema !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().build());
                        (0, MiningSchema_1.validateMiningFields)(modelIndex, miningSchema.MiningField, validationRegistry);
                    }
                });
        }
        return state;
    };
};
exports.MiningSchemaReducer = MiningSchemaReducer;
//# sourceMappingURL=MiningSchemaReducer.js.map