export declare enum AuthProviderType {
    NONE = "none",
    RH_ACCOUNT = "red-hat-account"
}
export interface SwfServiceRegistrySettings {
    name: string;
    url: string;
    authProvider: AuthProviderType;
}
export interface SwfServiceRegistriesSettings {
    registries: SwfServiceRegistrySettings[];
}
export declare enum SwfServiceCatalogServiceType {
    rest = "rest",
    graphql = "graphql",
    asyncapi = "asyncapi",
    camelroute = "camelroute"
}
export interface SwfServiceCatalogService {
    name: string;
    type: SwfServiceCatalogServiceType;
    source: SwfServiceCatalogServiceSource;
    functions: SwfServiceCatalogFunction[];
    events?: SwfServiceCatalogEvent[];
    rawContent: string;
}
export declare type SwfServiceCatalogServiceSource = {
    registry: string;
    id: string;
    url: string;
    type: SwfCatalogSourceType.SERVICE_REGISTRY;
} | {
    type: SwfCatalogSourceType.LOCAL_FS;
    absoluteFilePath: string;
};
export declare enum SwfServiceCatalogFunctionType {
    rest = "rest",
    graphql = "graphql",
    asyncapi = "asyncapi",
    custom = "custom"
}
export declare enum SwfServiceCatalogEventType {
    asyncapi = "asyncapi"
}
export declare enum SupportArtifactTypes {
    Openapi = "OPENAPI",
    Asyncapi = "ASYNCAPI",
    Camel = "CAMEL"
}
export declare enum SwfServiceCatalogFunctionArgumentType {
    boolean = "boolean",
    object = "object",
    number = "number",
    string = "string",
    integer = "integer",
    array = "array"
}
export declare enum SwfCatalogSourceType {
    SERVICE_REGISTRY = "SERVICE_REGISTRY",
    LOCAL_FS = "LOCAL_FS"
}
export declare enum SwfServiceCatalogEventKind {
    CONSUMED = "consumed",
    PRODUCED = "produced"
}
export declare type SwfServiceCatalogFunctionSource = {
    registry: string;
    serviceId: string;
    type: SwfCatalogSourceType.SERVICE_REGISTRY;
} | {
    type: SwfCatalogSourceType.LOCAL_FS;
    serviceFileAbsolutePath: string;
};
export declare type SwfServiceCatalogEventSource = {
    registry: string;
    serviceId: string;
    type: SwfCatalogSourceType.SERVICE_REGISTRY;
} | {
    type: SwfCatalogSourceType.LOCAL_FS;
    serviceFileAbsolutePath: string;
};
export interface SwfServiceCatalogFunction {
    source: SwfServiceCatalogFunctionSource;
    name: string;
    arguments: Record<string, SwfServiceCatalogFunctionArgumentType>;
    type: SwfServiceCatalogFunctionType;
}
export interface SwfServiceCatalogEvent {
    source: SwfServiceCatalogEventSource;
    name: string;
    kind: SwfServiceCatalogEventKind;
    type: SwfServiceCatalogEventType;
    eventSource: string;
    eventType: string;
}
//# sourceMappingURL=types.d.ts.map