var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { ExpandableRowContent } from "@patternfly/react-table/dist/js/components/Table";
import { TableComposable, Thead, Tbody, Tr, Th, Td } from "@patternfly/react-table/dist/js/components/TableComposable";
import _ from "lodash";
import ProcessListChildTable from "../ProcessListChildTable/ProcessListChildTable";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import { getProcessInstanceDescription, ProcessInstanceIconCreator } from "../utils/ProcessListUtils";
import ProcessListActionsKebab from "../ProcessListActionsKebab/ProcessListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import "../styles.css";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { TitleType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const ProcessListTable = ({ isLoading, expanded, setExpanded, sortBy, onSort, processInstances, setProcessInstances, selectedInstances, setSelectedInstances, selectableInstances, setSelectableInstances, setIsAllChecked, singularProcessLabel, pluralProcessLabel, isTriggerCloudEventEnabled, driver, ouiaId, ouiaSafe, }) => {
    const [rowPairs, setRowPairs] = useState([]);
    const columns = ["__Toggle", "__Select", "Id", "Status", "Created", "Last update", "__Actions"];
    const [modalTitle, setModalTitle] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [titleType, setTitleType] = useState("");
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [selectedProcessInstance, setSelectedProcessInstance] = useState();
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const onShowMessage = (title, content, type, processInstance) => {
        setSelectedProcessInstance(processInstance);
        setTitleType(type);
        setModalTitle(title);
        setModalContent(content);
        handleModalToggle();
    };
    const onSkipClick = (processInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleProcessSkip(processInstance);
            onShowMessage("Skip operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully skipped.`, TitleType.SUCCESS, processInstance);
        }
        catch (error) {
            onShowMessage("Skip operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} failed to skip. Message: ${error.message}`, TitleType.FAILURE, processInstance);
        }
        finally {
            handleModalToggle();
        }
    });
    const onRetryClick = (processInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleProcessRetry(processInstance);
            onShowMessage("Retry operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully re-executed.`, TitleType.SUCCESS, processInstance);
        }
        catch (error) {
            onShowMessage("Retry operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} failed to re-execute. Message: ${error.message}`, TitleType.FAILURE, processInstance);
        }
        finally {
            handleModalToggle();
        }
    });
    const onAbortClick = (processInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleProcessAbort(processInstance);
            onShowMessage("Abort operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully aborted.`, TitleType.SUCCESS, processInstance);
            processInstances.forEach((instance) => {
                if (instance.id === processInstance.id) {
                    instance.state = ProcessInstanceState.Aborted;
                }
            });
            setProcessInstances([...processInstances]);
        }
        catch (error) {
            onShowMessage("Abort operation", `Failed to abort ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName}. Message: ${error.message}`, TitleType.FAILURE, processInstance);
        }
        finally {
            handleModalToggle();
        }
    });
    const handleClick = (processInstance) => {
        driver.openProcess(processInstance);
    };
    useEffect(() => {
        if (!_.isEmpty(processInstances)) {
            const tempRows = [];
            processInstances.forEach((processInstance) => {
                var _a;
                tempRows.push({
                    id: processInstance.id,
                    parent: [
                        React.createElement(React.Fragment, null, ((_a = processInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) && processInstance.serviceUrl !== null ? (React.createElement(Checkbox, { isChecked: processInstance.isSelected, onChange: () => checkBoxSelect(processInstance), "aria-label": "process-list-checkbox", "data-testid": `checkbox-${processInstance.id}`, id: `checkbox-${processInstance.id}`, name: `checkbox-${processInstance.id}` })) : (React.createElement(DisablePopup, { processInstanceData: processInstance, component: React.createElement(Checkbox, { "aria-label": "process-list-checkbox-disabled", "data-testid": `checkbox-${processInstance.id}`, id: `checkbox-${processInstance.id}`, isDisabled: true }) }))),
                        React.createElement(React.Fragment, null,
                            React.createElement("a", Object.assign({ className: "kogito-process-list__link", onClick: () => handleClick(processInstance) }, componentOuiaProps(ouiaId, "process-description", ouiaSafe)),
                                React.createElement("strong", null,
                                    React.createElement(ItemDescriptor, { itemDescription: getProcessInstanceDescription(processInstance) }))),
                            React.createElement(EndpointLink, { serviceUrl: processInstance.serviceUrl, isLinkShown: false })),
                        processInstance.state === ProcessInstanceState.Error ? (React.createElement(ErrorPopover, { processInstanceData: processInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (ProcessInstanceIconCreator(processInstance.state)),
                        processInstance.start ? React.createElement(Moment, { fromNow: true }, new Date(`${processInstance.start}`)) : "",
                        processInstance.lastUpdate ? (React.createElement("span", null,
                            React.createElement(HistoryIcon, { className: "pf-u-mr-sm" }),
                            " ",
                            "Updated ",
                            React.createElement(Moment, { fromNow: true }, new Date(`${processInstance.lastUpdate}`)))) : (""),
                        React.createElement(ProcessListActionsKebab, { processInstance: processInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, key: processInstance.id }),
                    ],
                    child: [processInstance.id],
                });
            });
            setRowPairs(tempRows);
        }
        else {
            setRowPairs([]);
        }
    }, [processInstances]);
    const loadChild = (parentId, parentIndex) => {
        if (!expanded[parentIndex]) {
            return null;
        }
        else {
            return (React.createElement(ProcessListChildTable, { parentProcessId: parentId, processInstances: processInstances, setProcessInstances: setProcessInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, setSelectableInstances: setSelectableInstances, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel, driver: driver, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, ouiaId: parentId }));
        }
    };
    const checkBoxSelect = (processInstance) => {
        const clonedProcessInstances = [...processInstances];
        clonedProcessInstances.forEach((instance) => {
            if (processInstance.id === instance.id) {
                if (instance.isSelected) {
                    instance.isSelected = false;
                    setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== instance.id));
                }
                else {
                    instance.isSelected = true;
                    setSelectedInstances([...selectedInstances, instance]);
                }
            }
        });
        setProcessInstances(clonedProcessInstances);
    };
    const onToggle = (pairIndex, pair) => {
        var _a;
        setExpanded(Object.assign(Object.assign({}, expanded), { [pairIndex]: !expanded[pairIndex] }));
        if (expanded[pairIndex]) {
            const processInstance = processInstances.find((instance) => instance.id === pair.id);
            (_a = processInstance === null || processInstance === void 0 ? void 0 : processInstance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                if (childInstance.isSelected) {
                    const index = selectedInstances.findIndex((selectedInstance) => selectedInstance.id === childInstance.id);
                    if (index !== -1) {
                        selectedInstances.splice(index, 1);
                    }
                }
            });
            processInstances.forEach((instance) => {
                var _a;
                if ((processInstance === null || processInstance === void 0 ? void 0 : processInstance.id) === instance.id) {
                    instance.isOpen = false;
                    (_a = instance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((child) => {
                        var _a;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                            setSelectableInstances((prev) => prev - 1);
                        }
                    });
                }
            });
        }
        else {
            let processInstance;
            if (!_.isEmpty(processInstances)) {
                processInstance = processInstances.find((instance) => instance.id === pair.id);
                processInstances.forEach((instance) => {
                    if ((processInstance === null || processInstance === void 0 ? void 0 : processInstance.id) === instance.id) {
                        instance.isOpen = true;
                    }
                });
            }
        }
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(ProcessInfoModal, { isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalTitle: setTitle(titleType, modalTitle), modalContent: modalContent, processName: selectedProcessInstance && selectedProcessInstance.processName, ouiaId: selectedProcessInstance && "process-" + selectedProcessInstance.id }),
        React.createElement(TableComposable, Object.assign({ "data-testid": "process-list-table", "aria-label": "Process List Table" }, componentOuiaProps(ouiaId, "process-list-table", ouiaSafe ? ouiaSafe : !isLoading)),
            React.createElement(Thead, null,
                React.createElement(Tr, { ouiaId: "process-list-table-header" }, columns.map((column, columnIndex) => {
                    let sortParams = {};
                    if (!isLoading && rowPairs.length > 0) {
                        sortParams = {
                            sort: {
                                sortBy,
                                onSort,
                                columnIndex,
                            },
                        };
                    }
                    let styleParams;
                    switch (columnIndex) {
                        case 0:
                            styleParams = { width: "72px" };
                            sortParams = {};
                            break;
                        case 1:
                            styleParams = { width: "86px" };
                            sortParams = {};
                            break;
                        case columns.length - 1:
                            styleParams = { width: "188px" };
                            sortParams = {};
                            break;
                    }
                    return (React.createElement(Th, Object.assign({ style: styleParams, key: `${column}_header` }, sortParams), column.startsWith("__") ? "" : column));
                }))),
            !isLoading && !_.isEmpty(rowPairs) ? (rowPairs.map((pair, pairIndex) => {
                const parentRow = (React.createElement(Tr, Object.assign({ key: `${pair.id}-parent` }, componentOuiaProps(pair.id, "process-list-row", true)),
                    React.createElement(Td, Object.assign({ key: `${pair.id}-parent-0`, expand: {
                            rowIndex: pairIndex,
                            isExpanded: expanded[pairIndex],
                            onToggle: () => onToggle(pairIndex, pair),
                        } }, componentOuiaProps(columns[0].toLowerCase(), "process-list-cell", true))),
                    pair.parent.map((cell, cellIndex) => (React.createElement(Td, Object.assign({ key: `${pair.id}-parent-${columns[cellIndex + 1]}`, dataLabel: columns[cellIndex + 1] }, componentOuiaProps(columns[cellIndex + 1].toLowerCase(), "process-list-cell", true)), cell)))));
                const childRow = (React.createElement(Tr, Object.assign({ key: `${pair.id}-child`, isExpanded: expanded[pairIndex] === true }, componentOuiaProps(pair.id, "process-list-row-expanded", true)),
                    React.createElement(Td, { key: `${pair.id}-child-0` }),
                    rowPairs[pairIndex].child.map((cell, cellIndex) => (React.createElement(Td, { key: `${pair.id}-child-${columns[++cellIndex]}`, dataLabel: columns[cellIndex], noPadding: rowPairs[pairIndex].noPadding, colSpan: 6 },
                        React.createElement(ExpandableRowContent, null, loadChild(cell, pairIndex)))))));
                return (React.createElement(Tbody, { key: `${pair.id}_tBody` },
                    parentRow,
                    childRow));
            })) : (React.createElement("tbody", null,
                React.createElement(Tr, null,
                    React.createElement(Td, { colSpan: 7 },
                        React.createElement(React.Fragment, null,
                            isLoading && rowPairs.length === 0 && React.createElement(KogitoSpinner, { spinnerText: "Loading process instances..." }),
                            !isLoading && rowPairs.length === 0 && (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }))))))))));
};
export default ProcessListTable;
//# sourceMappingURL=ProcessListTable.js.map