var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import ProcessListTable from "../ProcessListTable/ProcessListTable";
import ProcessListToolbar from "../ProcessListToolbar/ProcessListToolbar";
import _ from "lodash";
import { alterOrderByObj, processListDefaultStatusFilter } from "../utils/ProcessListUtils";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { LoadMore } from "@kie-tools/runtime-tools-components/dist/components/LoadMore";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { OrderBy } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const ProcessList = ({ driver, isEnvelopeConnectedToChannel, initialState, singularProcessLabel, pluralProcessLabel, ouiaId, ouiaSafe, }) => {
    const defaultStatusFilter = processListDefaultStatusFilter;
    const defaultFilters = initialState && initialState.filters
        ? Object.assign({}, initialState.filters) : {
        status: defaultStatusFilter,
        businessKey: [],
    };
    const defaultOrderBy = initialState && initialState.sortBy
        ? initialState.sortBy
        : {
            lastUpdate: OrderBy.DESC,
        };
    const [defaultPageSize] = useState(10);
    const [isLoading, setIsLoading] = useState(false);
    const [isLoadingMore, setIsLoadingMore] = useState(false);
    const [offset, setOffset] = useState(0);
    const [limit, setLimit] = useState(defaultPageSize);
    const [pageSize, setPageSize] = useState(defaultPageSize);
    const [processInstances, setProcessInstances] = useState([]);
    const [error, setError] = useState();
    const [filters, setFilters] = useState(defaultFilters);
    const [processStates, setProcessStates] = useState(defaultStatusFilter);
    const [expanded, setExpanded] = React.useState({});
    const [sortBy, setSortBy] = useState(defaultOrderBy);
    const [selectedInstances, setSelectedInstances] = useState([]);
    const [selectableInstances, setSelectableInstances] = useState(0);
    const [isAllChecked, setIsAllChecked] = useState(false);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            initLoad();
        }
    }, [isEnvelopeConnectedToChannel]);
    useEffect(() => {
        setIsLoading(true);
        if (initialState && initialState.filters) {
            setFilters(initialState.filters);
            setProcessStates(initialState.filters.status);
            setSortBy(initialState.sortBy);
        }
    }, [initialState]);
    const initLoad = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setFilters(defaultFilters);
        yield driver.initialLoad(defaultFilters, defaultOrderBy);
        doQuery(0, 10, true);
    });
    const countExpandableRows = (instances) => {
        instances.forEach((processInstance, index) => {
            var _a;
            expanded[index] = false;
            processInstance.isSelected = false;
            processInstance.isOpen = false;
            processInstance.childProcessInstances = [];
            if (processInstance.serviceUrl && ((_a = processInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                setSelectableInstances((prev) => prev + 1);
            }
        });
    };
    const doQuery = (_offset, _limit, _resetProcesses, _resetPagination = false, _loadMore = false) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoadingMore(_loadMore);
        setSelectableInstances(0);
        setSelectedInstances([]);
        try {
            const response = yield driver.query(_offset, _limit);
            setLimit(response.length);
            if (_resetProcesses) {
                countExpandableRows(response);
                setProcessInstances(response);
            }
            else {
                const newData = processInstances.concat(response);
                countExpandableRows(newData);
                setProcessInstances(newData);
            }
            if (_resetPagination) {
                setOffset(_offset);
            }
        }
        catch (err) {
            setError(err.errorMessage);
        }
        finally {
            setIsLoading(false);
            setIsLoadingMore(false);
        }
    });
    useEffect(() => {
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    }, [processInstances]);
    const applyFilter = (filter) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setProcessInstances([]);
        yield driver.applyFilter(filter);
        doQuery(0, defaultPageSize, true, true);
    });
    const applySorting = (event, index, direction) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setProcessInstances([]);
        setSortBy({ index, direction });
        let sortingColumn = event.target.innerText;
        sortingColumn = _.camelCase(sortingColumn);
        let sortByObj = _.set({}, sortingColumn, direction.toUpperCase());
        sortByObj = alterOrderByObj(sortByObj);
        yield driver.applySorting(sortByObj);
        doQuery(0, defaultPageSize, true, true);
    });
    const doRefresh = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setProcessInstances([]);
        doQuery(0, defaultPageSize, true, true);
    });
    const doResetFilters = () => {
        const resetFilter = {
            status: defaultStatusFilter,
            businessKey: [],
        };
        setIsLoading(true);
        setProcessStates(defaultStatusFilter);
        setFilters(resetFilter);
        applyFilter(resetFilter);
    };
    const mustShowLoadMore = (!isLoading || isLoadingMore) && processInstances && limit === pageSize && filters.status.length > 0;
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "process-list", ouiaSafe ? ouiaSafe : !isLoading)),
        React.createElement(ProcessListToolbar, { applyFilter: applyFilter, refresh: doRefresh, filters: filters, setFilters: setFilters, processStates: processStates, setProcessStates: setProcessStates, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, processInstances: processInstances, setProcessInstances: setProcessInstances, isAllChecked: isAllChecked, setIsAllChecked: setIsAllChecked, driver: driver, defaultStatusFilter: defaultStatusFilter, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel }),
        filters.status.length > 0 ? (React.createElement(React.Fragment, null,
            React.createElement(ProcessListTable, { processInstances: processInstances, isLoading: isLoading, expanded: expanded, setExpanded: setExpanded, driver: driver, onSort: applySorting, sortBy: sortBy, setProcessInstances: setProcessInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, selectableInstances: selectableInstances, setSelectableInstances: setSelectableInstances, setIsAllChecked: setIsAllChecked, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel }),
            mustShowLoadMore && (React.createElement(LoadMore, { offset: offset, setOffset: setOffset, getMoreItems: (_offset, _limit) => {
                    setPageSize(_limit);
                    doQuery(_offset, _limit, false, true, true);
                }, pageSize: pageSize, isLoadingMore: isLoadingMore })))) : (React.createElement("div", { className: "kogito-process-list__emptyState-card" },
            React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Reset, title: "No filters applied.", body: "Try applying at least one filter to see results", onClick: doResetFilters })))));
};
export default ProcessList;
//# sourceMappingURL=ProcessList.js.map