import Moment from "react-moment";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import React from "react";
import { LevelDownAltIcon } from "@patternfly/react-icons/dist/js/icons/level-down-alt-icon";
import { LevelUpAltIcon } from "@patternfly/react-icons/dist/js/icons/level-up-alt-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ProcessInstanceIconCreator, getProcessInstanceDescription, } from "../../../../processList/envelope/components/utils/ProcessListUtils";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
const ProcessDetailsPanel = ({ processInstance, driver, ouiaId, ouiaSafe }) => {
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId ? ouiaId : processInstance.id, "process-details", ouiaSafe)),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Details")),
        React.createElement(CardBody, null,
            React.createElement(Form, null,
                React.createElement(FormGroup, { label: "Name", fieldId: "name" },
                    React.createElement(Text, { component: TextVariants.p }, processInstance.processName)),
                processInstance.businessKey && (React.createElement(FormGroup, { label: "Business key", fieldId: "businessKey" },
                    React.createElement(Text, { component: TextVariants.p }, processInstance.businessKey))),
                React.createElement(FormGroup, { label: "State", fieldId: "state" },
                    React.createElement(Text, { component: TextVariants.p }, ProcessInstanceIconCreator(processInstance.state))),
                React.createElement(FormGroup, { label: "Id", fieldId: "id" },
                    React.createElement(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak" }, processInstance.id)),
                processInstance.serviceUrl ? (React.createElement(FormGroup, { label: "Endpoint", fieldId: "endpoint" },
                    React.createElement(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak" },
                        React.createElement(EndpointLink, { serviceUrl: processInstance.serviceUrl, isLinkShown: true })))) : (""),
                React.createElement(FormGroup, { label: "Start", fieldId: "start" }, processInstance.start ? (React.createElement(Text, { component: TextVariants.p },
                    React.createElement(Moment, { fromNow: true }, new Date(`${processInstance.start}`)))) : ("")),
                processInstance.lastUpdate && (React.createElement(FormGroup, { label: "Last Updated", fieldId: "lastUpdate" },
                    React.createElement(Text, { component: TextVariants.p },
                        React.createElement(Moment, { fromNow: true }, new Date(`${processInstance.lastUpdate}`))))),
                processInstance.end && (React.createElement(FormGroup, { label: "End", fieldId: "end" },
                    React.createElement(Text, { component: TextVariants.p },
                        React.createElement(Moment, { fromNow: true }, new Date(`${processInstance.end}`))))),
                processInstance.parentProcessInstance !== null && (React.createElement(FormGroup, { label: "Parent Process", fieldId: "parent" },
                    React.createElement("div", null,
                        React.createElement(Button, Object.assign({ "data-testid": "open-parent-process", variant: "link", icon: React.createElement(LevelUpAltIcon, null), onClick: () => {
                                driver.openProcessInstanceDetails(processInstance.parentProcessInstance.id);
                            } }, componentOuiaProps(ouiaId ? ouiaId : processInstance.parentProcessInstance.id, "process-details", ouiaSafe)),
                            React.createElement(ItemDescriptor, { itemDescription: getProcessInstanceDescription(processInstance.parentProcessInstance) }))))),
                processInstance.childProcessInstances && processInstance.childProcessInstances.length !== 0 && (React.createElement(FormGroup, { label: "Sub Processes", fieldId: "child" }, processInstance.childProcessInstances.map((child) => (React.createElement("div", { key: child.id },
                    React.createElement(Button, Object.assign({ variant: "link", icon: React.createElement(LevelDownAltIcon, null), onClick: () => {
                            driver.openProcessInstanceDetails(child.id);
                        } }, componentOuiaProps(ouiaId ? ouiaId : child.id, "process-details", ouiaSafe)),
                        React.createElement(ItemDescriptor, { itemDescription: getProcessInstanceDescription(child) })))))))))));
};
export default ProcessDetailsPanel;
//# sourceMappingURL=ProcessDetailsPanel.js.map