import React, { useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import remove from "lodash/remove";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
var Category;
(function (Category) {
    Category["PROCESS_NAME"] = "Process name";
})(Category || (Category = {}));
const ProcessDefinitionListToolbar = ({ applyFilter, filterProcessNames, setFilterProcessNames, singularProcessLabel, ouiaSafe, ouiaId, }) => {
    const [processNameInput, setProcessNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter();
        setFilterProcessNames([]);
    };
    const doRefresh = () => {
        setFilterProcessNames([...filterProcessNames]);
        applyFilter();
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            processNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newfilterProcessNames = [...filterProcessNames];
        if (categoryName === Category.PROCESS_NAME) {
            remove(newfilterProcessNames, (status) => {
                return status === value;
            });
            setFilterProcessNames(newfilterProcessNames);
            applyFilter();
        }
    };
    const doApplyFilter = () => {
        const newProcessNames = [...filterProcessNames];
        if (processNameInput && !newProcessNames.includes(processNameInput)) {
            newProcessNames.push(processNameInput);
            setFilterProcessNames(newProcessNames);
        }
        setProcessNameInput("");
        applyFilter();
    };
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarFilter, { key: "input-process-name", chips: filterProcessNames, deleteChip: onDeleteFilterGroup, categoryName: Category.PROCESS_NAME },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "processName", id: "processName", type: "search", "aria-label": "process name", onChange: setProcessNameInput, onKeyPress: onEnterClicked, placeholder: `Filter by ${singularProcessLabel.toLowerCase()} name`, value: processNameInput }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, "data-testid": "apply-filter" }, "Apply Filter")))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: doRefresh, id: "refresh", "data-testid": "refresh" },
                        React.createElement(SyncIcon, null)))))));
    return (React.createElement(Toolbar, Object.assign({ id: "process-definition-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "process-definition-list-toolbar", ouiaSafe)),
        React.createElement(ToolbarContent, null, toolbarItems)));
};
export default ProcessDefinitionListToolbar;
//# sourceMappingURL=ProcessDefinitionListToolbar.js.map