"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmnEditorInterface = exports.DmnEditorFactory = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var api_1 = require("@kie-tools-core/editor/dist/api");
var DmnEditorRoot_1 = require("./DmnEditorRoot");
var api_2 = require("@kie-tools-core/workspace/dist/api");
var react_1 = require("react");
var DmnEditorFactory = (function () {
    function DmnEditorFactory() {
    }
    DmnEditorFactory.prototype.createEditor = function (envelopeContext, initArgs) {
        return Promise.resolve(new DmnEditorInterface(envelopeContext, initArgs));
    };
    return DmnEditorFactory;
}());
exports.DmnEditorFactory = DmnEditorFactory;
var DmnEditorInterface = (function () {
    function DmnEditorInterface(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.initArgs = initArgs;
        this.af_isReact = true;
    }
    DmnEditorInterface.prototype.getPreview = function () {
        return this.self.getDiagramSvg();
    };
    DmnEditorInterface.prototype.validate = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, Promise.resolve([])];
            });
        });
    };
    DmnEditorInterface.prototype.setTheme = function (theme) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, Promise.resolve()];
            });
        });
    };
    DmnEditorInterface.prototype.undo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.self.undo()];
            });
        });
    };
    DmnEditorInterface.prototype.redo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.self.redo()];
            });
        });
    };
    DmnEditorInterface.prototype.getContent = function () {
        return this.self.getContent();
    };
    DmnEditorInterface.prototype.setContent = function (normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return this.self.setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
    };
    DmnEditorInterface.prototype.af_componentRoot = function () {
        var _this = this;
        var _a;
        return ((0, jsx_runtime_1.jsx)(DmnEditorRootWrapper, { exposing: function (dmnEditorRoot) { return (_this.self = dmnEditorRoot); }, envelopeContext: this.envelopeContext, workspaceRootAbsolutePosixPath: (_a = this.initArgs.workspaceRootAbsolutePosixPath) !== null && _a !== void 0 ? _a : api_1.DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH }));
    };
    return DmnEditorInterface;
}());
exports.DmnEditorInterface = DmnEditorInterface;
function DmnEditorRootWrapper(_a) {
    var _this = this;
    var envelopeContext = _a.envelopeContext, exposing = _a.exposing, workspaceRootAbsolutePosixPath = _a.workspaceRootAbsolutePosixPath;
    var onNewEdit = (0, react_1.useCallback)(function (workspaceEdit) {
        envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.notifications.kogitoWorkspace_newEdit.send(workspaceEdit);
    }, [envelopeContext]);
    var onRequestWorkspaceFilesList = (0, react_1.useCallback)(function (resource) { return __awaiter(_this, void 0, void 0, function () {
        var _a;
        return __generator(this, function (_b) {
            return [2, ((_a = envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.requests.kogitoWorkspace_resourceListRequest(resource)) !== null && _a !== void 0 ? _a : new api_2.ResourcesList("", []))];
        });
    }); }, [envelopeContext]);
    var onRequestWorkspaceFileContent = (0, react_1.useCallback)(function (resource) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.requests.kogitoWorkspace_resourceContentRequest(resource)];
        });
    }); }, [envelopeContext]);
    var onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot = (0, react_1.useCallback)(function (normalizedPosixPathRelativeToTheWorkspaceRoot) {
        envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.notifications.kogitoWorkspace_openFile.send(normalizedPosixPathRelativeToTheWorkspaceRoot);
    }, [envelopeContext]);
    return ((0, jsx_runtime_1.jsx)(DmnEditorRoot_1.DmnEditorRoot, { exposing: exposing, onNewEdit: onNewEdit, onRequestWorkspaceFilesList: onRequestWorkspaceFilesList, onRequestWorkspaceFileContent: onRequestWorkspaceFileContent, onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot: onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot, workspaceRootAbsolutePosixPath: workspaceRootAbsolutePosixPath, keyboardShortcutsService: envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.services.keyboardShortcuts }));
}
//# sourceMappingURL=DmnEditorFactory.js.map